/*
 * Decompiled with CFR 0.152.
 */
package com.power.common.util;

import com.power.common.util.StringUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Collectors;

public class FileUtil {
    private static final String DEFAULT_CHARSET = "UTF-8";

    public static boolean mkdir(String path) {
        if (StringUtil.isEmpty(path)) {
            throw new NullPointerException("dir path can't null or empty");
        }
        File file = new File(path);
        return !file.exists() && file.mkdir();
    }

    public static boolean mkdirs(String path) {
        if (StringUtil.isEmpty(path)) {
            throw new NullPointerException("dir path can't null or empty");
        }
        File file = new File(path);
        return !file.exists() && file.mkdirs();
    }

    public static void copyDir(String path, String copyPath) {
        File filePath = new File(path);
        if (filePath.isDirectory()) {
            File[] list = filePath.listFiles();
            for (int i = 0; i < list.length; ++i) {
                String newPath = path + File.separator + list[i].getName();
                String newCopyPath = copyPath + File.separator + list[i].getName();
                File newFile = new File(copyPath);
                if (!newFile.exists()) {
                    newFile.mkdir();
                }
                FileUtil.nioTransferCopy(new File(newPath), new File(newCopyPath));
            }
        } else {
            throw new IllegalArgumentException(String.format("%s is not a directory", filePath.getAbsolutePath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nioTransferCopy(File source, File target) {
        AbstractInterruptibleChannel in = null;
        FileChannel out = null;
        FileInputStream inStream = null;
        FileOutputStream outStream = null;
        try {
            inStream = new FileInputStream(source);
            outStream = new FileOutputStream(target);
            in = inStream.getChannel();
            out = outStream.getChannel();
            ((FileChannel)in).transferTo(0L, ((FileChannel)in).size(), out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != inStream) {
                    inStream.close();
                }
                if (null != in) {
                    in.close();
                }
                if (null != outStream) {
                    outStream.close();
                }
                if (null != out) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static byte[] input2byte(InputStream inStream) throws IOException {
        int rc;
        ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
        byte[] buff = new byte[100];
        while ((rc = inStream.read(buff, 0, 100)) > 0) {
            swapStream.write(buff, 0, rc);
        }
        return swapStream.toByteArray();
    }

    public static boolean writeFile(String source, String filePath, boolean append) {
        return FileUtil.writeFile(source, filePath, append, DEFAULT_CHARSET);
    }

    public static boolean writeFileNotAppend(String source, String filePath) {
        return FileUtil.writeFile(source, filePath, false, DEFAULT_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFile(String source, String filePath, boolean append, String encoding) {
        boolean flag;
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)new FileOutputStream(filePath, append), encoding);
            osw.write(source);
            flag = true;
        }
        catch (IOException e) {
            e.printStackTrace();
            flag = false;
        }
        finally {
            try {
                osw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFile(String source, File file, boolean append) {
        boolean flag;
        BufferedWriter output = null;
        try {
            file.createNewFile();
            output = new BufferedWriter(new FileWriter(file, append));
            output.write(source);
            flag = true;
        }
        catch (IOException e) {
            e.printStackTrace();
            flag = false;
        }
        finally {
            try {
                if (null != output) {
                    output.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return flag;
    }

    public static String getFileContent(String fileName) {
        try {
            FileInputStream inputStream = new FileInputStream(fileName);
            return FileUtil.getFileContent(inputStream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileContent(InputStream inputStream) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(inputStream, DEFAULT_CHARSET));
            String string = reader.lines().collect(Collectors.joining("\n"));
            return string;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static File[] getResourceFolderFiles(String folder) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL url = loader.getResource(folder);
        if (null == url) {
            throw new RuntimeException("url is null");
        }
        String path = url.getPath();
        return new File(path).listFiles();
    }

    public static boolean nioWriteFile(String contents, String filePath) {
        return FileUtil.nioWriteFile(filePath, contents, null);
    }

    public static boolean nioWriteAppendable(String contents, String filePath) {
        return FileUtil.nioWriteFile(filePath, contents, StandardOpenOption.APPEND);
    }

    private static boolean nioWriteFile(String filePath, String contents, OpenOption openOption) {
        Path path = Paths.get(filePath, new String[0]);
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createFile(path, new FileAttribute[0]);
            }
            if (null == openOption) {
                Files.write(path, contents.getBytes(DEFAULT_CHARSET), new OpenOption[0]);
            } else {
                Files.write(path, contents.getBytes(DEFAULT_CHARSET), openOption);
            }
            return true;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static String toSuffix(String fileName) {
        String name = null;
        try {
            int index = fileName.lastIndexOf(".");
            name = fileName.substring(0, index);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return name;
    }
}

