/*
 * Decompiled with CFR 0.152.
 */
package com.github.tocrhz.mqtt.autoconfigure;

import com.github.tocrhz.mqtt.convert.PayloadDeserialize;
import com.github.tocrhz.mqtt.convert.PayloadSerialize;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;

public class MqttConversionService
extends GenericConversionService {
    private static final Logger log = LoggerFactory.getLogger(MqttConversionService.class);
    private static volatile MqttConversionService sharedInstance;

    public MqttConversionService() {
        MqttConversionService.configure((ConverterRegistry)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MqttConversionService getSharedInstance() {
        if (sharedInstance != null) return sharedInstance;
        Class<MqttConversionService> clazz = MqttConversionService.class;
        synchronized (MqttConversionService.class) {
            if (sharedInstance != null) return sharedInstance;
            sharedInstance = new MqttConversionService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sharedInstance;
        }
    }

    public static void configure(ConverterRegistry registry) {
        DefaultConversionService.addDefaultConverters((ConverterRegistry)registry);
        registry.addConverter(source -> source.getBytes(StandardCharsets.UTF_8));
        registry.addConverter(source -> new String((byte[])source, StandardCharsets.UTF_8));
        registry.addConverter(source -> Boolean.parseBoolean(new String((byte[])source, StandardCharsets.UTF_8)));
        registry.addConverter(source -> Byte.parseByte(new String((byte[])source, StandardCharsets.UTF_8)));
        registry.addConverter(source -> Short.parseShort(new String((byte[])source, StandardCharsets.UTF_8)));
        registry.addConverter(source -> Integer.parseInt(new String((byte[])source, StandardCharsets.UTF_8)));
        registry.addConverter(source -> Long.parseLong(new String((byte[])source, StandardCharsets.UTF_8)));
        registry.addConverter(source -> Float.valueOf(Float.parseFloat(new String((byte[])source, StandardCharsets.UTF_8))));
        registry.addConverter(source -> Double.parseDouble(new String((byte[])source, StandardCharsets.UTF_8)));
    }

    public static void addBeans(ConverterRegistry registry, ListableBeanFactory beanFactory) {
        LinkedHashSet beans = new LinkedHashSet();
        beans.addAll(beanFactory.getBeansOfType(PayloadDeserialize.class).values());
        beans.addAll(beanFactory.getBeansOfType(PayloadSerialize.class).values());
        beans.addAll(beanFactory.getBeansOfType(ConverterFactory.class).values());
        beans.addAll(beanFactory.getBeansOfType(GenericConverter.class).values());
        beans.addAll(beanFactory.getBeansOfType(Converter.class).values());
        for (Object bean : beans) {
            if (bean instanceof PayloadDeserialize) {
                registry.addConverterFactory((ConverterFactory)((PayloadDeserialize)bean));
                continue;
            }
            if (bean instanceof ConverterFactory) {
                registry.addConverterFactory((ConverterFactory)bean);
                continue;
            }
            if (bean instanceof PayloadSerialize) {
                registry.addConverter((Converter)((PayloadSerialize)bean));
                continue;
            }
            if (bean instanceof GenericConverter) {
                registry.addConverter((GenericConverter)bean);
                continue;
            }
            if (!(bean instanceof Converter)) continue;
            registry.addConverter((Converter)bean);
        }
    }

    public byte[] toBytes(Object source) {
        if (source == null) {
            return null;
        }
        Class<?> src = source.getClass();
        if (src == byte[].class) {
            return (byte[])source;
        }
        if (this.canConvert(src, byte[].class)) {
            return (byte[])this.convert(source, byte[].class);
        }
        if (this.canConvert(src, String.class)) {
            String temporary = (String)this.convert(source, String.class);
            if (temporary == null) {
                log.warn("Execute covert from {} to {} return null.", (Object)src.getName(), byte[].class);
                return null;
            }
            return temporary.getBytes(StandardCharsets.UTF_8);
        }
        log.warn("Unsupported covert from {} to {}", (Object)src.getName(), byte[].class);
        return null;
    }

    public Object fromBytes(byte[] source, Class<?> target, List<Converter<Object, Object>> converters) {
        if (source == null) {
            return null;
        }
        Object payload = source;
        if (converters != null && !converters.isEmpty()) {
            for (Converter<Object, Object> converter : converters) {
                try {
                    if (payload == null) {
                        log.warn("Execute covert {} return null.", (Object)converter.getClass().getName());
                        return null;
                    }
                    payload = converter.convert(payload);
                }
                catch (Exception e) {
                    log.error("Execute covert {} failed.", (Object)converter.getClass().getName(), (Object)e);
                    return null;
                }
            }
        }
        if (payload == null) {
            return null;
        }
        Class<?> src = payload.getClass();
        if (target == src) {
            return payload;
        }
        if (this.canConvert(src, target)) {
            return this.convert(payload, target);
        }
        if (this.canConvert(String.class, target)) {
            return this.convert(this.convert(payload, String.class), target);
        }
        log.warn("Unsupported covert from {} to {}", (Object)src.getName(), (Object)target.getName());
        return null;
    }

    static interface ByteArrayToDoubleConverter
    extends Converter<byte[], Double> {
    }

    static interface ByteArrayToFloatConverter
    extends Converter<byte[], Float> {
    }

    static interface ByteArrayToLongConverter
    extends Converter<byte[], Long> {
    }

    static interface ByteArrayToIntegerConverter
    extends Converter<byte[], Integer> {
    }

    static interface ByteArrayToShortConverter
    extends Converter<byte[], Short> {
    }

    static interface ByteArrayToByteConverter
    extends Converter<byte[], Byte> {
    }

    static interface ByteArrayToBooleanConverter
    extends Converter<byte[], Boolean> {
    }

    static interface ByteArrayToStringConverter
    extends Converter<byte[], String> {
    }

    static interface StringToByteArrayConverter
    extends Converter<String, byte[]> {
    }
}

