/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.AsyncDatastoreServiceInternal;
import com.google.appengine.api.datastore.DatastoreAttributes;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.FutureHelper;
import com.google.appengine.api.datastore.Index;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyRange;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionOptions;
import java.util.Collection;
import java.util.List;
import java.util.Map;

final class DatastoreServiceImpl
implements DatastoreService {
    private final AsyncDatastoreServiceInternal async;

    public DatastoreServiceImpl(AsyncDatastoreServiceInternal async) {
        this.async = async;
    }

    @Override
    public Transaction getCurrentTransaction() {
        return this.async.getCurrentTransaction();
    }

    @Override
    public Transaction getCurrentTransaction(Transaction returnedIfNoTxn) {
        return this.async.getCurrentTransaction(returnedIfNoTxn);
    }

    @Override
    public Entity get(Transaction txn, Key key) throws EntityNotFoundException {
        return FutureHelper.quietGet(this.async.get(txn, key), EntityNotFoundException.class);
    }

    @Override
    public Entity get(Key key) throws EntityNotFoundException {
        return FutureHelper.quietGet(this.async.get(key), EntityNotFoundException.class);
    }

    @Override
    public Map<Key, Entity> get(Iterable<Key> keys) {
        return FutureHelper.quietGet(this.async.get(keys));
    }

    @Override
    public Map<Key, Entity> get(Transaction txn, Iterable<Key> keys) {
        return FutureHelper.quietGet(this.async.get(txn, keys));
    }

    @Override
    public Key put(Entity entity) {
        return FutureHelper.quietGet(this.async.put(entity));
    }

    @Override
    public Key put(Transaction txn, Entity entity) {
        return FutureHelper.quietGet(this.async.put(txn, entity));
    }

    @Override
    public List<Key> put(Iterable<Entity> entities) {
        return FutureHelper.quietGet(this.async.put(entities));
    }

    @Override
    public List<Key> put(Transaction txn, Iterable<Entity> entities) {
        return FutureHelper.quietGet(this.async.put(txn, entities));
    }

    @Override
    public void delete(Key ... keys) {
        FutureHelper.quietGet(this.async.delete(keys));
    }

    @Override
    public void delete(Transaction txn, Key ... keys) {
        FutureHelper.quietGet(this.async.delete(txn, keys));
    }

    @Override
    public void delete(Iterable<Key> keys) {
        FutureHelper.quietGet(this.async.delete(keys));
    }

    @Override
    public void delete(Transaction txn, Iterable<Key> keys) {
        FutureHelper.quietGet(this.async.delete(txn, keys));
    }

    @Override
    public PreparedQuery prepare(Query query) {
        return this.async.prepare(query);
    }

    @Override
    public PreparedQuery prepare(Transaction txn, Query query) {
        return this.async.prepare(txn, query);
    }

    @Override
    public Collection<Transaction> getActiveTransactions() {
        return this.async.getActiveTransactions();
    }

    @Override
    public KeyRange allocateIds(String kind, long num) {
        return FutureHelper.quietGet(this.async.allocateIds(kind, num));
    }

    @Override
    public KeyRange allocateIds(Key parent, String kind, long num) {
        return FutureHelper.quietGet(this.async.allocateIds(parent, kind, num));
    }

    @Override
    public DatastoreService.KeyRangeState allocateIdRange(KeyRange range) {
        return FutureHelper.quietGet(this.async.allocateIdRange(range));
    }

    @Override
    public Transaction beginTransaction() {
        return FutureHelper.quietGet(this.async.beginTransaction());
    }

    @Override
    public Transaction beginTransaction(TransactionOptions options) {
        return FutureHelper.quietGet(this.async.beginTransaction(options));
    }

    @Override
    public DatastoreAttributes getDatastoreAttributes() {
        return FutureHelper.quietGet(this.async.getDatastoreAttributes());
    }

    @Override
    public Map<Index, Index.IndexState> getIndexes() {
        return FutureHelper.quietGet(this.async.getIndexes());
    }
}

