/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.mail.stdimpl;

import com.google.appengine.api.mail.MailService;
import com.google.appengine.api.mail.MailServiceFactory;
import com.google.appengine.repackaged.com.google.common.base.Joiner;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.URLName;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class GMTransport
extends Transport {
    private static final String FILENAME_PREVENTS_INLINING_PROPERTY = "appengine.mail.filenamePreventsInlining";
    private static final String SUPPORT_EXTENDED_ATTACHMENT_ENCODINGS_PROPERTY = "appengine.mail.supportExtendedAttachmentEncodings";
    private static final String ADMINS_ADDRESS = "admins";
    private static final String[] HEADERS_WHITELIST = new String[]{"Auto-Submitted", "In-Reply-To", "List-Id", "List-Unsubscribe", "On-Behalf-Of", "References", "Resent-Date", "Resent-From", "Resent-To"};

    public GMTransport(Session session, URLName urlName) {
        super(session, urlName);
    }

    @Override
    protected boolean protocolConnect(String host, int port, String user, String password) {
        return true;
    }

    private boolean canInline(Message message, BodyPart bodyPart) throws MessagingException {
        if (!FilenamePreventsInlininHolder.INSTANCE) {
            return true;
        }
        if (message.isMimeType("multipart/alternative")) {
            return true;
        }
        if (bodyPart instanceof MimeBodyPart) {
            MimeBodyPart mimeBodyPart = (MimeBodyPart)bodyPart;
            return mimeBodyPart.getFileName() == null || mimeBodyPart.getFileName().isEmpty();
        }
        return true;
    }

    @Override
    public void sendMessage(Message message, Address[] addresses) throws MessagingException {
        Address senderAddr22;
        MailService service = MailServiceFactory.getMailService();
        MailService.Message msg = new MailService.Message();
        String sender = null;
        if (message instanceof MimeMessage && (senderAddr22 = ((MimeMessage)message).getSender()) != null) {
            sender = senderAddr22.toString();
        }
        if (sender == null && message.getFrom() != null && message.getFrom().length > 0) {
            sender = message.getFrom()[0].toString();
        }
        msg.setSender(sender);
        try {
            msg.setReplyTo(Joiner.on(", ").useForNull("null").join(message.getReplyTo()));
        }
        catch (NullPointerException senderAddr22) {
            // empty catch block
        }
        boolean toAdmins = false;
        Address[] allRecipients = message.getAllRecipients();
        if (allRecipients != null) {
            for (Address addr : allRecipients) {
                if (!ADMINS_ADDRESS.equals(addr.toString())) continue;
                toAdmins = true;
            }
        }
        if (!toAdmins) {
            HashSet<String> allAddresses = new HashSet<String>();
            for (Address addr : addresses) {
                allAddresses.add(addr.toString());
            }
            msg.setTo(this.convertAddressFields(message.getRecipients(MimeMessage.RecipientType.TO), allAddresses));
            msg.setCc(this.convertAddressFields(message.getRecipients(MimeMessage.RecipientType.CC), allAddresses));
            msg.setBcc(this.convertAddressFields(message.getRecipients(MimeMessage.RecipientType.BCC), allAddresses));
        }
        msg.setSubject(message.getSubject());
        Object textObject = null;
        Object htmlObject = null;
        Object ampHtmlObject = null;
        String textType = null;
        String htmlType = null;
        String ampHtmlType = null;
        Multipart otherMessageParts = null;
        ArrayList<MailService.Header> headers = new ArrayList<MailService.Header>();
        Enumeration originalHeaders = message.getMatchingHeaders(HEADERS_WHITELIST);
        while (originalHeaders.hasMoreElements()) {
            Header header = (Header)originalHeaders.nextElement();
            headers.add(new MailService.Header(header.getName(), header.getValue()));
        }
        msg.setHeaders(headers);
        if (message.getContentType() == null) {
            try {
                textObject = message.getContent();
                textType = message.getContentType();
            }
            catch (IOException e) {
                throw new MessagingException("Getting typeless content failed", e);
            }
        }
        if (message.isMimeType("text/html")) {
            try {
                htmlObject = message.getContent();
                htmlType = message.getContentType();
            }
            catch (IOException e) {
                throw new MessagingException("Getting html content failed", e);
            }
        }
        if (message.isMimeType("text/*")) {
            try {
                textObject = message.getContent();
                textType = message.getContentType();
            }
            catch (IOException e) {
                throw new MessagingException("Getting text/* content failed", e);
            }
        }
        if (message.isMimeType("multipart/*")) {
            try {
                Multipart mp = (Multipart)message.getContent();
                for (int i = 0; i < mp.getCount(); ++i) {
                    BodyPart bp = mp.getBodyPart(i);
                    if (bp.isMimeType("text/plain") && textObject == null && this.canInline(message, bp)) {
                        textObject = bp.getContent();
                        textType = bp.getContentType();
                        continue;
                    }
                    if (bp.isMimeType("text/html") && htmlObject == null && this.canInline(message, bp)) {
                        htmlObject = bp.getContent();
                        htmlType = bp.getContentType();
                        continue;
                    }
                    if (bp.isMimeType("text/x-amp-html") && ampHtmlObject == null && this.canInline(message, bp)) {
                        ampHtmlObject = bp.getContent();
                        ampHtmlType = bp.getContentType();
                        continue;
                    }
                    if (otherMessageParts == null) {
                        String type = mp.getContentType();
                        assert (type.startsWith("multipart/"));
                        otherMessageParts = new MimeMultipart(type.substring("multipart/".length()));
                    }
                    otherMessageParts.addBodyPart(bp);
                }
            }
            catch (IOException e) {
                throw new MessagingException("Getting multipart content failed", e);
            }
        }
        if (textObject != null) {
            msg.setTextBody(this.convertAttachmentToString(textObject, textType));
        }
        if (htmlObject != null) {
            msg.setHtmlBody(this.convertAttachmentToString(htmlObject, htmlType));
        }
        if (ampHtmlObject != null) {
            msg.setAmpHtmlBody(this.convertAttachmentToString(ampHtmlObject, ampHtmlType));
        }
        if (otherMessageParts != null) {
            msg.setAttachments(this.convertAttachments(otherMessageParts));
        }
        try {
            if (toAdmins) {
                service.sendToAdmins(msg);
            } else {
                service.send(msg);
            }
        }
        catch (IOException e) {
            this.notifyTransportListeners(2, new Address[0], addresses, new Address[0], message);
            throw new SendFailedException("MailService IO failed", e);
        }
        catch (IllegalArgumentException e) {
            throw new MessagingException("Illegal Arguments", e);
        }
        this.notifyTransportListeners(1, addresses, new Address[0], new Address[0], message);
    }

    ArrayList<MailService.Attachment> convertAttachments(Multipart multipart) throws MessagingException {
        ArrayList<MailService.Attachment> result = new ArrayList<MailService.Attachment>();
        this.convertAttachments(multipart, result);
        return result;
    }

    private void convertAttachments(Multipart multipart, List<MailService.Attachment> result) throws MessagingException {
        for (int i = 0; i < multipart.getCount(); ++i) {
            byte[] data;
            String name;
            BodyPart bp;
            block8: {
                bp = multipart.getBodyPart(i);
                name = bp.getFileName();
                try {
                    Object o = bp.getContent();
                    if (o instanceof InputStream) {
                        data = this.inputStreamToBytes((InputStream)o);
                        break block8;
                    }
                    if (o instanceof String) {
                        data = ((String)o).getBytes();
                        break block8;
                    }
                    if (SupportExtendedAttachmentEncodingsHolder.INSTANCE && o instanceof byte[]) {
                        data = (byte[])o;
                        break block8;
                    }
                    if (SupportExtendedAttachmentEncodingsHolder.INSTANCE && o instanceof Multipart) {
                        this.convertAttachments((Multipart)o, result);
                        continue;
                    }
                    throw new MessagingException("Converting attachment data failed");
                }
                catch (IOException e) {
                    throw new MessagingException("Extracting attachment data failed", e);
                }
            }
            String contentID = null;
            String[] contentIDHeaders = bp.getHeader("content-id");
            if (contentIDHeaders != null) {
                contentID = contentIDHeaders[0];
            }
            MailService.Attachment attachment = new MailService.Attachment(name, data, contentID);
            result.add(attachment);
        }
    }

    public int hashCode() {
        return this.session.hashCode() * 13 + this.url.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GMTransport) {
            GMTransport transport = (GMTransport)obj;
            return this.session.equals(transport.session) && this.url.equals(transport.url);
        }
        return false;
    }

    private Collection<String> convertAddressFields(Address[] targetAddrs, Set<String> allAddrs) {
        if (targetAddrs == null || targetAddrs.length == 0) {
            return null;
        }
        ArrayList<String> ourAddrs = new ArrayList<String>(targetAddrs.length);
        for (Address addr : targetAddrs) {
            String email = addr.toString();
            if (!allAddrs.contains(email)) continue;
            ourAddrs.add(email);
        }
        return ourAddrs;
    }

    private String convertAttachmentToString(Object attachmentData, String type) throws MessagingException {
        String[] args;
        String charset = null;
        for (String arg : args = type.split(";")) {
            if (!arg.trim().startsWith("charset=")) continue;
            charset = arg.split("=")[1];
            break;
        }
        try {
            byte[] attachmentBytes = null;
            if (attachmentData instanceof String) {
                return (String)attachmentData;
            }
            if (SupportExtendedAttachmentEncodingsHolder.INSTANCE && attachmentData instanceof byte[]) {
                attachmentBytes = (byte[])attachmentData;
            } else if (attachmentData instanceof InputStream) {
                attachmentBytes = this.inputStreamToBytes((InputStream)attachmentData);
            } else {
                throw new MessagingException(new StringBuilder(31 + String.valueOf(type).length()).append("Converting body of type ").append(type).append(" failed").toString());
            }
            if (charset != null) {
                return new String(attachmentBytes, charset);
            }
            return new String(attachmentBytes);
        }
        catch (UnsupportedEncodingException e) {
            String string = String.valueOf(charset);
            throw new MessagingException(string.length() != 0 ? "Unsupported charset: ".concat(string) : new String("Unsupported charset: "), e);
        }
        catch (IOException e) {
            throw new MessagingException(new StringBuilder(33 + String.valueOf(type).length()).append("Stringifying body of type ").append(type).append(" failed").toString(), e);
        }
    }

    private byte[] inputStreamToBytes(InputStream in) throws IOException {
        byte[] bytes = new byte[in.available()];
        int count = in.read(bytes);
        return bytes;
    }

    private static class FilenamePreventsInlininHolder {
        static final boolean INSTANCE = Boolean.getBoolean("appengine.mail.filenamePreventsInlining");

        private FilenamePreventsInlininHolder() {
        }
    }

    private static class SupportExtendedAttachmentEncodingsHolder {
        static final boolean INSTANCE = Boolean.getBoolean("appengine.mail.supportExtendedAttachmentEncodings");

        private SupportExtendedAttachmentEncodingsHolder() {
        }
    }
}

