/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time.tz;

import com.google.appengine.repackaged.org.joda.time.DateTimeUtils;
import com.google.appengine.repackaged.org.joda.time.tz.NameProvider;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class DefaultNameProvider
implements NameProvider {
    private HashMap<Locale, Map<String, Map<String, Object>>> iByLocaleCache = this.createCache();
    private HashMap<Locale, Map<String, Map<Boolean, Object>>> iByLocaleCache2 = this.createCache();

    @Override
    public String getShortName(Locale locale, String id, String nameKey) {
        String[] nameSet = this.getNameSet(locale, id, nameKey);
        return nameSet == null ? null : nameSet[0];
    }

    @Override
    public String getName(Locale locale, String id, String nameKey) {
        String[] nameSet = this.getNameSet(locale, id, nameKey);
        return nameSet == null ? null : nameSet[1];
    }

    private synchronized String[] getNameSet(Locale locale, String id, String nameKey) {
        HashMap byNameKeyCache;
        if (locale == null || id == null || nameKey == null) {
            return null;
        }
        HashMap byIdCache = this.iByLocaleCache.get(locale);
        if (byIdCache == null) {
            byIdCache = this.createCache();
            this.iByLocaleCache.put(locale, byIdCache);
        }
        if ((byNameKeyCache = byIdCache.get(id)) == null) {
            byNameKeyCache = this.createCache();
            byIdCache.put(id, byNameKeyCache);
            String[][] zoneStringsEn = DateTimeUtils.getDateFormatSymbols(Locale.ENGLISH).getZoneStrings();
            String[] setEn = null;
            for (String[] strings : zoneStringsEn) {
                if (strings == null || strings.length < 5 || !id.equals(strings[0])) continue;
                setEn = strings;
                break;
            }
            String[][] zoneStringsLoc = DateTimeUtils.getDateFormatSymbols(locale).getZoneStrings();
            String[] setLoc = null;
            for (String[] strings : zoneStringsLoc) {
                if (strings == null || strings.length < 5 || !id.equals(strings[0])) continue;
                setLoc = strings;
                break;
            }
            if (setEn != null && setLoc != null) {
                byNameKeyCache.put(setEn[2], new String[]{setLoc[2], setLoc[1]});
                if (setEn[2].equals(setEn[4])) {
                    byNameKeyCache.put(String.valueOf(setEn[4]).concat("-Summer"), new String[]{setLoc[4], setLoc[3]});
                } else {
                    byNameKeyCache.put(setEn[4], new String[]{setLoc[4], setLoc[3]});
                }
            }
        }
        return (String[])byNameKeyCache.get(nameKey);
    }

    public String getShortName(Locale locale, String id, String nameKey, boolean standardTime) {
        String[] nameSet = this.getNameSet(locale, id, nameKey, standardTime);
        return nameSet == null ? null : nameSet[0];
    }

    public String getName(Locale locale, String id, String nameKey, boolean standardTime) {
        String[] nameSet = this.getNameSet(locale, id, nameKey, standardTime);
        return nameSet == null ? null : nameSet[1];
    }

    private synchronized String[] getNameSet(Locale locale, String id, String nameKey, boolean standardTime) {
        HashMap byNameKeyCache;
        if (locale == null || id == null || nameKey == null) {
            return null;
        }
        HashMap byIdCache = this.iByLocaleCache2.get(locale);
        if (byIdCache == null) {
            byIdCache = this.createCache();
            this.iByLocaleCache2.put(locale, byIdCache);
        }
        if ((byNameKeyCache = byIdCache.get(id)) == null) {
            byNameKeyCache = this.createCache();
            byIdCache.put(id, byNameKeyCache);
            String[][] zoneStringsEn = DateTimeUtils.getDateFormatSymbols(Locale.ENGLISH).getZoneStrings();
            String[] setEn = null;
            for (String[] strings : zoneStringsEn) {
                if (strings == null || strings.length < 5 || !id.equals(strings[0])) continue;
                setEn = strings;
                break;
            }
            String[][] zoneStringsLoc = DateTimeUtils.getDateFormatSymbols(locale).getZoneStrings();
            String[] setLoc = null;
            for (String[] strings : zoneStringsLoc) {
                if (strings == null || strings.length < 5 || !id.equals(strings[0])) continue;
                setLoc = strings;
                break;
            }
            if (setEn != null && setLoc != null) {
                byNameKeyCache.put(Boolean.TRUE, new String[]{setLoc[2], setLoc[1]});
                byNameKeyCache.put(Boolean.FALSE, new String[]{setLoc[4], setLoc[3]});
            }
        }
        return (String[])byNameKeyCache.get(standardTime);
    }

    private HashMap createCache() {
        return new HashMap(7);
    }
}

