/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.aztec.encoder;

import com.google.zxing.aztec.encoder.AztecCode;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.reedsolomon.GenericGF;
import com.google.zxing.common.reedsolomon.ReedSolomonEncoder;
import java.util.Arrays;

public final class Encoder {
    public static final int DEFAULT_EC_PERCENT = 33;
    private static final int TABLE_UPPER = 0;
    private static final int TABLE_LOWER = 1;
    private static final int TABLE_DIGIT = 2;
    private static final int TABLE_MIXED = 3;
    private static final int TABLE_PUNCT = 4;
    private static final int TABLE_BINARY = 5;
    private static final int[][] CHAR_MAP;
    private static final int[][] SHIFT_TABLE;
    private static final int[][] LATCH_TABLE;
    private static final int[] NB_BITS;
    private static final int[] NB_BITS_COMPACT;
    private static final int[] WORD_SIZE;

    private Encoder() {
    }

    public static AztecCode encode(byte[] data) {
        return Encoder.encode(data, 33);
    }

    public static AztecCode encode(byte[] data, int minECCPercent) {
        int i;
        int matrixSize;
        int layers;
        BitArray bits = Encoder.highLevelEncode(data);
        int eccBits = bits.getSize() * minECCPercent / 100 + 11;
        int totalSizeBits = bits.getSize() + eccBits;
        int wordSize = 0;
        int totalSymbolBits = 0;
        BitArray stuffedBits = null;
        for (layers = 1; layers < NB_BITS_COMPACT.length; ++layers) {
            if (NB_BITS_COMPACT[layers] < totalSizeBits) continue;
            if (wordSize != WORD_SIZE[layers]) {
                wordSize = WORD_SIZE[layers];
                stuffedBits = Encoder.stuffBits(bits, wordSize);
            }
            totalSymbolBits = NB_BITS_COMPACT[layers];
            if (stuffedBits.getSize() + eccBits <= NB_BITS_COMPACT[layers]) break;
        }
        boolean compact = true;
        if (layers == NB_BITS_COMPACT.length) {
            compact = false;
            for (layers = 1; layers < NB_BITS.length; ++layers) {
                if (NB_BITS[layers] < totalSizeBits) continue;
                if (wordSize != WORD_SIZE[layers]) {
                    wordSize = WORD_SIZE[layers];
                    stuffedBits = Encoder.stuffBits(bits, wordSize);
                }
                totalSymbolBits = NB_BITS[layers];
                if (stuffedBits.getSize() + eccBits <= NB_BITS[layers]) break;
            }
        }
        if (layers == NB_BITS.length) {
            throw new IllegalArgumentException("Data too large for an Aztec code");
        }
        int messageSizeInWords = (stuffedBits.getSize() + wordSize - 1) / wordSize;
        ReedSolomonEncoder rs = new ReedSolomonEncoder(Encoder.getGF(wordSize));
        int totalSizeInFullWords = totalSymbolBits / wordSize;
        int[] messageWords = Encoder.bitsToWords(stuffedBits, wordSize, totalSizeInFullWords);
        rs.encode(messageWords, totalSizeInFullWords - messageSizeInWords);
        int startPad = totalSymbolBits % wordSize;
        BitArray messageBits = new BitArray();
        messageBits.appendBits(0, startPad);
        for (int messageWord : messageWords) {
            messageBits.appendBits(messageWord, wordSize);
        }
        BitArray modeMessage = Encoder.generateModeMessage(compact, layers, messageSizeInWords);
        int baseMatrixSize = compact ? 11 + layers * 4 : 14 + layers * 4;
        int[] alignmentMap = new int[baseMatrixSize];
        if (compact) {
            matrixSize = baseMatrixSize;
            for (int i2 = 0; i2 < alignmentMap.length; ++i2) {
                alignmentMap[i2] = i2;
            }
        } else {
            matrixSize = baseMatrixSize + 1 + 2 * ((baseMatrixSize / 2 - 1) / 15);
            int origCenter = baseMatrixSize / 2;
            int center = matrixSize / 2;
            for (int i3 = 0; i3 < origCenter; ++i3) {
                int newOffset = i3 + i3 / 15;
                alignmentMap[origCenter - i3 - 1] = center - newOffset - 1;
                alignmentMap[origCenter + i3] = center + newOffset + 1;
            }
        }
        BitMatrix matrix = new BitMatrix(matrixSize);
        int rowOffset = 0;
        for (i = 0; i < layers; ++i) {
            int rowSize = compact ? (layers - i) * 4 + 9 : (layers - i) * 4 + 12;
            for (int j = 0; j < rowSize; ++j) {
                int columnOffset = j * 2;
                for (int k = 0; k < 2; ++k) {
                    if (messageBits.get(rowOffset + columnOffset + k)) {
                        matrix.set(alignmentMap[i * 2 + k], alignmentMap[i * 2 + j]);
                    }
                    if (messageBits.get(rowOffset + rowSize * 2 + columnOffset + k)) {
                        matrix.set(alignmentMap[i * 2 + j], alignmentMap[baseMatrixSize - 1 - i * 2 - k]);
                    }
                    if (messageBits.get(rowOffset + rowSize * 4 + columnOffset + k)) {
                        matrix.set(alignmentMap[baseMatrixSize - 1 - i * 2 - k], alignmentMap[baseMatrixSize - 1 - i * 2 - j]);
                    }
                    if (!messageBits.get(rowOffset + rowSize * 6 + columnOffset + k)) continue;
                    matrix.set(alignmentMap[baseMatrixSize - 1 - i * 2 - j], alignmentMap[i * 2 + k]);
                }
            }
            rowOffset += rowSize * 8;
        }
        Encoder.drawModeMessage(matrix, compact, matrixSize, modeMessage);
        if (compact) {
            Encoder.drawBullsEye(matrix, matrixSize / 2, 5);
        } else {
            Encoder.drawBullsEye(matrix, matrixSize / 2, 7);
            i = 0;
            int j = 0;
            while (i < baseMatrixSize / 2 - 1) {
                for (int k = matrixSize / 2 & 1; k < matrixSize; k += 2) {
                    matrix.set(matrixSize / 2 - j, k);
                    matrix.set(matrixSize / 2 + j, k);
                    matrix.set(k, matrixSize / 2 - j);
                    matrix.set(k, matrixSize / 2 + j);
                }
                i += 15;
                j += 16;
            }
        }
        AztecCode aztec = new AztecCode();
        aztec.setCompact(compact);
        aztec.setSize(matrixSize);
        aztec.setLayers(layers);
        aztec.setCodeWords(messageSizeInWords);
        aztec.setMatrix(matrix);
        return aztec;
    }

    static void drawBullsEye(BitMatrix matrix, int center, int size) {
        for (int i = 0; i < size; i += 2) {
            for (int j = center - i; j <= center + i; ++j) {
                matrix.set(j, center - i);
                matrix.set(j, center + i);
                matrix.set(center - i, j);
                matrix.set(center + i, j);
            }
        }
        matrix.set(center - size, center - size);
        matrix.set(center - size + 1, center - size);
        matrix.set(center - size, center - size + 1);
        matrix.set(center + size, center - size);
        matrix.set(center + size, center - size + 1);
        matrix.set(center + size, center + size - 1);
    }

    static BitArray generateModeMessage(boolean compact, int layers, int messageSizeInWords) {
        BitArray modeMessage = new BitArray();
        if (compact) {
            modeMessage.appendBits(layers - 1, 2);
            modeMessage.appendBits(messageSizeInWords - 1, 6);
            modeMessage = Encoder.generateCheckWords(modeMessage, 28, 4);
        } else {
            modeMessage.appendBits(layers - 1, 5);
            modeMessage.appendBits(messageSizeInWords - 1, 11);
            modeMessage = Encoder.generateCheckWords(modeMessage, 40, 4);
        }
        return modeMessage;
    }

    static void drawModeMessage(BitMatrix matrix, boolean compact, int matrixSize, BitArray modeMessage) {
        if (compact) {
            for (int i = 0; i < 7; ++i) {
                if (modeMessage.get(i)) {
                    matrix.set(matrixSize / 2 - 3 + i, matrixSize / 2 - 5);
                }
                if (modeMessage.get(i + 7)) {
                    matrix.set(matrixSize / 2 + 5, matrixSize / 2 - 3 + i);
                }
                if (modeMessage.get(20 - i)) {
                    matrix.set(matrixSize / 2 - 3 + i, matrixSize / 2 + 5);
                }
                if (!modeMessage.get(27 - i)) continue;
                matrix.set(matrixSize / 2 - 5, matrixSize / 2 - 3 + i);
            }
        } else {
            for (int i = 0; i < 10; ++i) {
                if (modeMessage.get(i)) {
                    matrix.set(matrixSize / 2 - 5 + i + i / 5, matrixSize / 2 - 7);
                }
                if (modeMessage.get(i + 10)) {
                    matrix.set(matrixSize / 2 + 7, matrixSize / 2 - 5 + i + i / 5);
                }
                if (modeMessage.get(29 - i)) {
                    matrix.set(matrixSize / 2 - 5 + i + i / 5, matrixSize / 2 + 7);
                }
                if (!modeMessage.get(39 - i)) continue;
                matrix.set(matrixSize / 2 - 7, matrixSize / 2 - 5 + i + i / 5);
            }
        }
    }

    static BitArray generateCheckWords(BitArray stuffedBits, int totalSymbolBits, int wordSize) {
        int messageSizeInWords = (stuffedBits.getSize() + wordSize - 1) / wordSize;
        for (int i = messageSizeInWords * wordSize - stuffedBits.getSize(); i > 0; --i) {
            stuffedBits.appendBit(true);
        }
        ReedSolomonEncoder rs = new ReedSolomonEncoder(Encoder.getGF(wordSize));
        int totalSizeInFullWords = totalSymbolBits / wordSize;
        int[] messageWords = Encoder.bitsToWords(stuffedBits, wordSize, totalSizeInFullWords);
        rs.encode(messageWords, totalSizeInFullWords - messageSizeInWords);
        int startPad = totalSymbolBits % wordSize;
        BitArray messageBits = new BitArray();
        messageBits.appendBits(0, startPad);
        for (int messageWord : messageWords) {
            messageBits.appendBits(messageWord, wordSize);
        }
        return messageBits;
    }

    static int[] bitsToWords(BitArray stuffedBits, int wordSize, int totalWords) {
        int[] message = new int[totalWords];
        int n = stuffedBits.getSize() / wordSize;
        for (int i = 0; i < n; ++i) {
            int value = 0;
            for (int j = 0; j < wordSize; ++j) {
                value |= stuffedBits.get(i * wordSize + j) ? 1 << wordSize - j - 1 : 0;
            }
            message[i] = value;
        }
        return message;
    }

    static GenericGF getGF(int wordSize) {
        switch (wordSize) {
            case 4: {
                return GenericGF.AZTEC_PARAM;
            }
            case 6: {
                return GenericGF.AZTEC_DATA_6;
            }
            case 8: {
                return GenericGF.AZTEC_DATA_8;
            }
            case 10: {
                return GenericGF.AZTEC_DATA_10;
            }
            case 12: {
                return GenericGF.AZTEC_DATA_12;
            }
        }
        return null;
    }

    static BitArray stuffBits(BitArray bits, int wordSize) {
        BitArray out = new BitArray();
        int n = bits.getSize();
        int mask = (1 << wordSize) - 2;
        for (int i = 0; i < n; i += wordSize) {
            int word = 0;
            for (int j = 0; j < wordSize; ++j) {
                if (i + j < n && !bits.get(i + j)) continue;
                word |= 1 << wordSize - 1 - j;
            }
            if ((word & mask) == mask) {
                out.appendBits(word & mask, wordSize);
                --i;
                continue;
            }
            if ((word & mask) == 0) {
                out.appendBits(word | 1, wordSize);
                --i;
                continue;
            }
            out.appendBits(word, wordSize);
        }
        return out;
    }

    static BitArray highLevelEncode(byte[] data) {
        BitArray bits = new BitArray();
        int mode = 0;
        int[] idx = new int[5];
        int[] idxnext = new int[5];
        for (int i = 0; i < data.length; ++i) {
            int k;
            int j;
            int c = data[i] & 0xFF;
            int next = i < data.length - 1 ? data[i + 1] & 0xFF : 0;
            int punctWord = 0;
            if (c == 13 && next == 10) {
                punctWord = 2;
            } else if (c == 46 && next == 32) {
                punctWord = 3;
            } else if (c == 44 && next == 32) {
                punctWord = 4;
            } else if (c == 58 && next == 32) {
                punctWord = 5;
            }
            if (punctWord > 0) {
                if (mode == 4) {
                    Encoder.outputWord(bits, 4, punctWord);
                    ++i;
                    continue;
                }
                if (SHIFT_TABLE[mode][4] >= 0) {
                    Encoder.outputWord(bits, mode, SHIFT_TABLE[mode][4]);
                    Encoder.outputWord(bits, 4, punctWord);
                    ++i;
                    continue;
                }
                if (LATCH_TABLE[mode][4] >= 0) {
                    Encoder.outputWord(bits, mode, LATCH_TABLE[mode][4]);
                    Encoder.outputWord(bits, 4, punctWord);
                    mode = 4;
                    ++i;
                    continue;
                }
            }
            int firstMatch = -1;
            int shiftMode = -1;
            int latchMode = -1;
            for (j = 0; j < 5; ++j) {
                idx[j] = CHAR_MAP[j][c];
                if (idx[j] > 0 && firstMatch < 0) {
                    firstMatch = j;
                }
                if (shiftMode < 0 && idx[j] > 0 && SHIFT_TABLE[mode][j] >= 0) {
                    shiftMode = j;
                }
                idxnext[j] = CHAR_MAP[j][next];
                if (latchMode >= 0 || idx[j] <= 0 || next != 0 && idxnext[j] <= 0 || LATCH_TABLE[mode][j] < 0) continue;
                latchMode = j;
            }
            if (shiftMode < 0 && latchMode < 0) {
                for (j = 0; j < 5; ++j) {
                    if (idx[j] <= 0 || LATCH_TABLE[mode][j] < 0) continue;
                    latchMode = j;
                    break;
                }
            }
            if (idx[mode] > 0) {
                Encoder.outputWord(bits, mode, idx[mode]);
                continue;
            }
            if (latchMode >= 0) {
                Encoder.outputWord(bits, mode, LATCH_TABLE[mode][latchMode]);
                Encoder.outputWord(bits, latchMode, idx[latchMode]);
                mode = latchMode;
                continue;
            }
            if (shiftMode >= 0) {
                Encoder.outputWord(bits, mode, SHIFT_TABLE[mode][shiftMode]);
                Encoder.outputWord(bits, shiftMode, idx[shiftMode]);
                continue;
            }
            if (firstMatch >= 0) {
                if (mode == 4) {
                    Encoder.outputWord(bits, 4, LATCH_TABLE[4][0]);
                    mode = 0;
                    --i;
                    continue;
                }
                if (mode == 2) {
                    Encoder.outputWord(bits, 2, LATCH_TABLE[2][0]);
                    mode = 0;
                    --i;
                    continue;
                }
            }
            int lookahead = 0;
            for (k = i + 1; k < data.length; ++k) {
                next = data[k] & 0xFF;
                boolean binary = true;
                for (j = 0; j < 5; ++j) {
                    if (CHAR_MAP[j][next] <= 0) continue;
                    binary = false;
                    break;
                }
                if (binary) {
                    lookahead = 0;
                    continue;
                }
                if (lookahead >= 1) {
                    k -= lookahead;
                    break;
                }
                ++lookahead;
            }
            k -= i;
            switch (mode) {
                case 0: 
                case 1: 
                case 3: {
                    Encoder.outputWord(bits, mode, SHIFT_TABLE[mode][5]);
                    break;
                }
                case 2: {
                    Encoder.outputWord(bits, mode, LATCH_TABLE[mode][0]);
                    mode = 0;
                    Encoder.outputWord(bits, mode, SHIFT_TABLE[mode][5]);
                    break;
                }
                case 4: {
                    Encoder.outputWord(bits, mode, LATCH_TABLE[mode][0]);
                    mode = 0;
                    Encoder.outputWord(bits, mode, SHIFT_TABLE[mode][5]);
                }
            }
            if (k >= 32 && k < 63) {
                k = 31;
            }
            if (k > 542) {
                k = 542;
            }
            if (k < 32) {
                bits.appendBits(k, 5);
            } else {
                bits.appendBits(k - 31, 16);
            }
            while (k > 0) {
                bits.appendBits(data[i], 8);
                --k;
                ++i;
            }
            --i;
        }
        return bits;
    }

    static void outputWord(BitArray bits, int mode, int value) {
        if (mode == 2) {
            bits.appendBits(value, 4);
        } else if (mode < 5) {
            bits.appendBits(value, 5);
        } else {
            bits.appendBits(value, 8);
        }
    }

    static {
        int i;
        int c;
        CHAR_MAP = new int[5][256];
        SHIFT_TABLE = new int[6][6];
        LATCH_TABLE = new int[6][6];
        Encoder.CHAR_MAP[0][32] = 1;
        for (c = 65; c <= 90; ++c) {
            Encoder.CHAR_MAP[0][c] = c - 65 + 2;
        }
        Encoder.CHAR_MAP[1][32] = 1;
        for (c = 97; c <= 122; ++c) {
            Encoder.CHAR_MAP[1][c] = c - 97 + 2;
        }
        Encoder.CHAR_MAP[2][32] = 1;
        for (c = 48; c <= 57; ++c) {
            Encoder.CHAR_MAP[2][c] = c - 48 + 2;
        }
        Encoder.CHAR_MAP[2][44] = 12;
        Encoder.CHAR_MAP[2][46] = 13;
        int[] mixedTable = new int[]{0, 32, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 27, 28, 29, 30, 31, 64, 92, 94, 95, 96, 124, 126, 127};
        for (int i2 = 0; i2 < mixedTable.length; ++i2) {
            Encoder.CHAR_MAP[3][mixedTable[i2]] = i2;
        }
        int[] punctTable = new int[]{0, 13, 0, 0, 0, 0, 33, 39, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 58, 59, 60, 61, 62, 63, 91, 93, 123, 125};
        for (int i3 = 0; i3 < punctTable.length; ++i3) {
            if (punctTable[i3] <= 0) continue;
            Encoder.CHAR_MAP[4][punctTable[i3]] = i3;
        }
        for (int[] table : SHIFT_TABLE) {
            Arrays.fill(table, -1);
        }
        for (int[] table : LATCH_TABLE) {
            Arrays.fill(table, -1);
        }
        Encoder.SHIFT_TABLE[0][4] = 0;
        Encoder.LATCH_TABLE[0][1] = 28;
        Encoder.LATCH_TABLE[0][3] = 29;
        Encoder.LATCH_TABLE[0][2] = 30;
        Encoder.SHIFT_TABLE[0][5] = 31;
        Encoder.SHIFT_TABLE[1][4] = 0;
        Encoder.SHIFT_TABLE[1][0] = 28;
        Encoder.LATCH_TABLE[1][3] = 29;
        Encoder.LATCH_TABLE[1][2] = 30;
        Encoder.SHIFT_TABLE[1][5] = 31;
        Encoder.SHIFT_TABLE[3][4] = 0;
        Encoder.LATCH_TABLE[3][1] = 28;
        Encoder.LATCH_TABLE[3][0] = 29;
        Encoder.LATCH_TABLE[3][4] = 30;
        Encoder.SHIFT_TABLE[3][5] = 31;
        Encoder.LATCH_TABLE[4][0] = 31;
        Encoder.SHIFT_TABLE[2][4] = 0;
        Encoder.LATCH_TABLE[2][0] = 30;
        Encoder.SHIFT_TABLE[2][0] = 31;
        NB_BITS_COMPACT = new int[5];
        for (i = 1; i < NB_BITS_COMPACT.length; ++i) {
            Encoder.NB_BITS_COMPACT[i] = (88 + 16 * i) * i;
        }
        NB_BITS = new int[33];
        for (i = 1; i < NB_BITS.length; ++i) {
            Encoder.NB_BITS[i] = (112 + 16 * i) * i;
        }
        WORD_SIZE = new int[]{4, 6, 6, 8, 8, 8, 8, 8, 8, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
    }
}

