/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.code.interpreter;

import com.googlecode.aviator.InterpretExpression;
import com.googlecode.aviator.code.interpreter.IR;
import com.googlecode.aviator.lexer.token.Token;
import com.googlecode.aviator.parser.VariableMeta;
import com.googlecode.aviator.runtime.RuntimeUtils;
import com.googlecode.aviator.runtime.type.AviatorJavaType;
import com.googlecode.aviator.runtime.type.AviatorNil;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.utils.Env;
import java.util.ArrayDeque;
import java.util.List;

public class InterpretContext {
    private final ArrayDeque<AviatorObject> operands = new ArrayDeque();
    private IR pc;
    private int pcIndex = -1;
    private IR[] instruments = new IR[0];
    private final Env env;
    private final InterpretExpression expression;
    private boolean reachEnd;
    private final boolean trace;

    public InterpretContext(InterpretExpression exp, List<IR> instruments, Env env) {
        this.expression = exp;
        this.instruments = instruments.toArray(this.instruments);
        this.env = env;
        this.trace = RuntimeUtils.isTracedEval(env);
        this.next();
    }

    public AviatorJavaType loadVar(VariableMeta v) {
        return this.expression.loadVar(v);
    }

    public AviatorObject loadConstant(Token<?> token) {
        return this.expression.loadConstant(token);
    }

    public boolean isReachEnd() {
        return this.reachEnd;
    }

    public ArrayDeque<AviatorObject> getOperands() {
        return this.operands;
    }

    public void clearStack() {
        this.operands.clear();
    }

    public void jumpTo(int tpc) {
        if (tpc == this.instruments.length) {
            this.pc = null;
            this.pcIndex = -1;
            this.reachEnd = true;
            return;
        }
        this.pcIndex = tpc;
        this.pc = this.instruments[this.pcIndex];
    }

    public InterpretExpression getExpression() {
        return this.expression;
    }

    public Env getEnv() {
        return this.env;
    }

    public boolean next() {
        if (this.reachEnd) {
            return false;
        }
        ++this.pcIndex;
        if (this.pcIndex < this.instruments.length) {
            this.pc = this.instruments[this.pcIndex];
            return true;
        }
        return false;
    }

    public IR getPc() {
        return this.pc;
    }

    public void push(AviatorObject ... args) {
        for (AviatorObject arg : args) {
            if (arg == null) {
                arg = AviatorNil.NIL;
            }
            this.operands.push(arg);
        }
    }

    public AviatorObject peek() {
        return this.operands.peek();
    }

    public AviatorObject pop() {
        return this.operands.pop();
    }

    public String descOperandsStack() {
        StringBuilder sb = new StringBuilder("<Stack, [");
        int i = this.operands.size();
        for (AviatorObject obj : this.operands) {
            sb.append(obj.desc(this.env));
            if (--i <= 0) continue;
            sb.append(", ");
        }
        sb.append("]>");
        return sb.toString();
    }

    public void dispatch() {
        this.dispatch(true);
    }

    public void dispatch(boolean next) {
        if (next && !this.next()) {
            return;
        }
        if (this.pc != null) {
            if (this.trace) {
                RuntimeUtils.printlnTrace(this.env, "    " + this.pc + "    " + this.descOperandsStack());
            }
            this.pc.eval(this);
        }
    }
}

