/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.type;

import com.googlecode.aviator.Options;
import com.googlecode.aviator.exception.CompareNotSupportedException;
import com.googlecode.aviator.exception.ExpressionRuntimeException;
import com.googlecode.aviator.lexer.SymbolTable;
import com.googlecode.aviator.runtime.RuntimeUtils;
import com.googlecode.aviator.runtime.function.DispatchFunction;
import com.googlecode.aviator.runtime.function.LambdaFunction;
import com.googlecode.aviator.runtime.type.AviatorBoolean;
import com.googlecode.aviator.runtime.type.AviatorNil;
import com.googlecode.aviator.runtime.type.AviatorNumber;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorPattern;
import com.googlecode.aviator.runtime.type.AviatorRuntimeJavaElementType;
import com.googlecode.aviator.runtime.type.AviatorRuntimeJavaType;
import com.googlecode.aviator.runtime.type.AviatorString;
import com.googlecode.aviator.runtime.type.AviatorType;
import com.googlecode.aviator.utils.Constants;
import com.googlecode.aviator.utils.Env;
import com.googlecode.aviator.utils.Reflector;
import com.googlecode.aviator.utils.TypeUtils;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;

public class AviatorJavaType
extends AviatorObject {
    private static final long serialVersionUID = -4353225521490659987L;
    protected String name;
    private final boolean containsDot;
    private String[] subNames;

    @Override
    public AviatorType getAviatorType() {
        return AviatorType.JavaType;
    }

    public String getName() {
        return this.name;
    }

    public AviatorJavaType(String name) {
        this(name, null);
    }

    public AviatorJavaType(String name, SymbolTable symbolTable) {
        if (name != null) {
            String rName = AviatorJavaType.reserveName(name);
            this.name = rName != null ? rName : (symbolTable != null ? symbolTable.reserve(name).getLexeme() : name);
            this.containsDot = this.name.contains(".");
        } else {
            this.name = null;
            this.containsDot = false;
        }
    }

    public static String reserveName(String name) {
        if ("__env__".equals(name)) {
            return "__env__";
        }
        if (Constants.ReducerEmptyVal.getLexeme().equals(name)) {
            return Constants.ReducerEmptyVal.getLexeme();
        }
        if ("__args__".equals(name)) {
            return "__args__";
        }
        if ("__reducer_loop".equals(name)) {
            return "__reducer_loop";
        }
        if ("__instance__".equals(name)) {
            return "__instance__";
        }
        if ("__exp__".equals(name)) {
            return "__exp__";
        }
        return null;
    }

    @Override
    public AviatorObject deref(Map<String, Object> env) {
        return AviatorRuntimeJavaType.valueOf(this.getValue(env));
    }

    @Override
    public AviatorObject div(AviatorObject other, Map<String, Object> env) {
        Object value = this.getValue(env);
        switch (other.getAviatorType()) {
            case BigInt: 
            case Decimal: 
            case Long: 
            case Double: {
                if (value instanceof Number) {
                    AviatorNumber aviatorNumber = AviatorNumber.valueOf(value);
                    return aviatorNumber.div(other, env);
                }
                return super.div(other, env);
            }
            case JavaType: {
                if (value instanceof Number) {
                    AviatorNumber thisAviatorNumber = AviatorNumber.valueOf(value);
                    return thisAviatorNumber.div(other, env);
                }
                return super.div(other, env);
            }
        }
        return super.div(other, env);
    }

    @Override
    public AviatorObject match(AviatorObject other, Map<String, Object> env) {
        Object val = this.getValue(env);
        if (val instanceof Pattern) {
            return new AviatorPattern((Pattern)val).match(other, env);
        }
        return super.match(other, env);
    }

    @Override
    public AviatorObject bitAnd(AviatorObject other, Map<String, Object> env) {
        Object value = this.getValue(env);
        switch (other.getAviatorType()) {
            case BigInt: 
            case Decimal: 
            case Long: 
            case Double: {
                if (value instanceof Number) {
                    AviatorNumber aviatorNumber = AviatorNumber.valueOf(value);
                    return aviatorNumber.bitAnd(other, env);
                }
                return super.bitAnd(other, env);
            }
            case JavaType: {
                if (value instanceof Number) {
                    AviatorNumber thisAviatorNumber = AviatorNumber.valueOf(value);
                    return thisAviatorNumber.bitAnd(other, env);
                }
                return super.bitAnd(other, env);
            }
        }
        return super.bitAnd(other, env);
    }

    @Override
    public AviatorObject bitNot(Map<String, Object> env) {
        Object value = this.getValue(env);
        if (value instanceof Number) {
            return AviatorNumber.valueOf(value).bitNot(env);
        }
        return super.bitNot(env);
    }

    @Override
    public AviatorObject bitOr(AviatorObject other, Map<String, Object> env) {
        Object value = this.getValue(env);
        switch (other.getAviatorType()) {
            case BigInt: 
            case Decimal: 
            case Long: 
            case Double: {
                if (value instanceof Number) {
                    AviatorNumber aviatorNumber = AviatorNumber.valueOf(value);
                    return aviatorNumber.bitOr(other, env);
                }
                return super.bitOr(other, env);
            }
            case JavaType: {
                if (value instanceof Number) {
                    AviatorNumber thisAviatorNumber = AviatorNumber.valueOf(value);
                    return thisAviatorNumber.bitOr(other, env);
                }
                return super.bitOr(other, env);
            }
        }
        return super.bitOr(other, env);
    }

    @Override
    public AviatorObject bitXor(AviatorObject other, Map<String, Object> env) {
        Object value = this.getValue(env);
        switch (other.getAviatorType()) {
            case BigInt: 
            case Decimal: 
            case Long: 
            case Double: {
                if (value instanceof Number) {
                    AviatorNumber aviatorNumber = AviatorNumber.valueOf(value);
                    return aviatorNumber.bitXor(other, env);
                }
                return super.bitXor(other, env);
            }
            case JavaType: {
                if (value instanceof Number) {
                    AviatorNumber thisAviatorNumber = AviatorNumber.valueOf(value);
                    return thisAviatorNumber.bitXor(other, env);
                }
                return super.bitXor(other, env);
            }
        }
        return super.bitXor(other, env);
    }

    @Override
    public AviatorObject shiftLeft(AviatorObject other, Map<String, Object> env) {
        Object value = this.getValue(env);
        switch (other.getAviatorType()) {
            case BigInt: 
            case Decimal: 
            case Long: 
            case Double: {
                if (value instanceof Number) {
                    AviatorNumber aviatorNumber = AviatorNumber.valueOf(value);
                    return aviatorNumber.shiftLeft(other, env);
                }
                return super.shiftLeft(other, env);
            }
            case JavaType: {
                if (value instanceof Number) {
                    AviatorNumber thisAviatorNumber = AviatorNumber.valueOf(value);
                    return thisAviatorNumber.shiftLeft(other, env);
                }
                return super.shiftLeft(other, env);
            }
        }
        return super.shiftLeft(other, env);
    }

    @Override
    public AviatorObject shiftRight(AviatorObject other, Map<String, Object> env) {
        Object value = this.getValue(env);
        switch (other.getAviatorType()) {
            case BigInt: 
            case Decimal: 
            case Long: 
            case Double: {
                if (value instanceof Number) {
                    AviatorNumber aviatorNumber = AviatorNumber.valueOf(value);
                    return aviatorNumber.shiftRight(other, env);
                }
                return super.shiftRight(other, env);
            }
            case JavaType: {
                if (value instanceof Number) {
                    AviatorNumber thisAviatorNumber = AviatorNumber.valueOf(value);
                    return thisAviatorNumber.shiftRight(other, env);
                }
                return super.shiftRight(other, env);
            }
        }
        return super.shiftRight(other, env);
    }

    @Override
    public AviatorObject unsignedShiftRight(AviatorObject other, Map<String, Object> env) {
        Object value = this.getValue(env);
        switch (other.getAviatorType()) {
            case BigInt: 
            case Decimal: 
            case Long: 
            case Double: {
                if (value instanceof Number) {
                    AviatorNumber aviatorNumber = AviatorNumber.valueOf(value);
                    return aviatorNumber.unsignedShiftRight(other, env);
                }
                return super.unsignedShiftRight(other, env);
            }
            case JavaType: {
                if (value instanceof Number) {
                    AviatorNumber thisAviatorNumber = AviatorNumber.valueOf(value);
                    return thisAviatorNumber.unsignedShiftRight(other, env);
                }
                return super.unsignedShiftRight(other, env);
            }
        }
        return super.unsignedShiftRight(other, env);
    }

    @Override
    public Object getValue(Map<String, Object> env) {
        return this.getValueFromEnv(this.name, this.containsDot, env, true);
    }

    public Object getValueFromEnv(String name, boolean nameContainsDot, Map<String, Object> env, boolean throwExceptionNotFound) {
        if (env != null) {
            if (nameContainsDot && !env.containsKey(name) && RuntimeUtils.getInstance(env).getOptionValue((Options)Options.ENABLE_PROPERTY_SYNTAX_SUGAR).bool) {
                if (this.subNames == null) {
                    this.subNames = Constants.SPLIT_PAT.split(name);
                }
                return AviatorJavaType.getProperty(name, this.subNames, env, throwExceptionNotFound, false);
            }
            return env.get(name);
        }
        return null;
    }

    public static Object getValueFromEnv(String name, boolean nameContainsDot, String[] names, Map<String, Object> env, boolean throwExceptionNotFound, boolean tryResolveStaticMethod) {
        if (env != null) {
            if (nameContainsDot && RuntimeUtils.getInstance(env).getOptionValue((Options)Options.ENABLE_PROPERTY_SYNTAX_SUGAR).bool) {
                return AviatorJavaType.getProperty(name, names, env, throwExceptionNotFound, tryResolveStaticMethod);
            }
            return env.get(name);
        }
        return null;
    }

    @Override
    public AviatorObject defineValue(AviatorObject value, Map<String, Object> env) {
        if (this.containsDot) {
            return this.setProperty(value, env);
        }
        Object v = this.getAssignedValue(value, env);
        if (v instanceof LambdaFunction) {
            Object existsFn = this.getValue(env);
            if (existsFn instanceof DispatchFunction) {
                ((DispatchFunction)existsFn).install((LambdaFunction)v);
                return AviatorRuntimeJavaType.valueOf(existsFn);
            }
            if (existsFn instanceof LambdaFunction) {
                DispatchFunction newFn = new DispatchFunction(this.name);
                newFn.install((LambdaFunction)existsFn);
                newFn.install((LambdaFunction)v);
                v = newFn;
            } else if (existsFn == null && ((LambdaFunction)v).isVariadic()) {
                DispatchFunction newFn = new DispatchFunction(this.name);
                newFn.install((LambdaFunction)v);
                v = newFn;
            }
        }
        ((Env)env).override(this.name, v);
        return AviatorRuntimeJavaType.valueOf(v);
    }

    private Object getAssignedValue(AviatorObject value, Map<String, Object> env) {
        Object v = value.getValue(env);
        if (v instanceof AviatorObject) {
            v = ((AviatorObject)v).deref(env);
        }
        return v;
    }

    @Override
    public AviatorObject setValue(AviatorObject value, Map<String, Object> env) {
        if (this.containsDot) {
            return this.setProperty(value, env);
        }
        Object v = this.getAssignedValue(value, env);
        env.put(this.name, v);
        return AviatorRuntimeJavaType.valueOf(v);
    }

    private AviatorObject setProperty(AviatorObject value, Map<String, Object> env) {
        if (RuntimeUtils.getInstance(env).getOptionValue((Options)Options.ENABLE_PROPERTY_SYNTAX_SUGAR).bool) {
            Object v = value.getValue(env);
            try {
                Reflector.setProperty(env, this.name, value.getValue(env));
            }
            catch (Throwable t) {
                if (RuntimeUtils.getInstance(env).getOptionValue((Options)Options.TRACE_EVAL).bool) {
                    t.printStackTrace();
                }
                throw Reflector.sneakyThrow(t);
            }
            return AviatorRuntimeJavaType.valueOf(v);
        }
        throw new ExpressionRuntimeException("Can't assign value to " + this.name + ", Options.ENABLE_PROPERTY_SYNTAX_SUGAR is disabled.");
    }

    public static Object getProperty(String name, String[] names, Map<String, Object> env, boolean throwExceptionNotFound, boolean tryResolveStaticMethod) {
        try {
            if (names == null) {
                names = Constants.SPLIT_PAT.split(name);
            }
            return Reflector.fastGetProperty(name, names, env, Reflector.Target.withEnv(env), tryResolveStaticMethod, 0, names.length);
        }
        catch (Throwable t) {
            if (RuntimeUtils.getInstance(env).getOptionValue((Options)Options.TRACE_EVAL).bool) {
                t.printStackTrace();
            }
            if (RuntimeUtils.getInstance(env).getOptionValue((Options)Options.NIL_WHEN_PROPERTY_NOT_FOUND).bool) {
                return null;
            }
            if (throwExceptionNotFound) {
                throw new ExpressionRuntimeException("Could not find variable " + name, t);
            }
            return null;
        }
    }

    public static Object tryResolveAsClass(Map<String, Object> env, String rName) {
        try {
            return ((Env)env).resolveClassSymbol(rName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public AviatorObject mod(AviatorObject other, Map<String, Object> env) {
        Object value = this.getValue(env);
        switch (other.getAviatorType()) {
            case BigInt: 
            case Decimal: 
            case Long: 
            case Double: {
                if (value instanceof Number) {
                    AviatorNumber aviatorNumber = AviatorNumber.valueOf(value);
                    return aviatorNumber.mod(other, env);
                }
                return super.mod(other, env);
            }
            case JavaType: {
                if (value instanceof Number) {
                    AviatorNumber thisAviatorNumber = AviatorNumber.valueOf(value);
                    return thisAviatorNumber.mod(other, env);
                }
                return super.mod(other, env);
            }
        }
        return super.mod(other, env);
    }

    @Override
    public AviatorObject sub(AviatorObject other, Map<String, Object> env) {
        Object value = this.getValue(env);
        switch (other.getAviatorType()) {
            case BigInt: 
            case Decimal: 
            case Long: 
            case Double: {
                if (value instanceof Number) {
                    AviatorNumber aviatorNumber = AviatorNumber.valueOf(value);
                    return aviatorNumber.sub(other, env);
                }
                return super.sub(other, env);
            }
            case JavaType: {
                if (value instanceof Number) {
                    AviatorNumber thisAviatorNumber = AviatorNumber.valueOf(value);
                    return thisAviatorNumber.sub(other, env);
                }
                return super.sub(other, env);
            }
        }
        return super.sub(other, env);
    }

    @Override
    public int innerCompare(AviatorObject other, Map<String, Object> env) {
        if (this == other) {
            return 0;
        }
        switch (other.getAviatorType()) {
            case BigInt: 
            case Decimal: 
            case Long: 
            case Double: {
                AviatorNumber aviatorNumber = (AviatorNumber)other;
                return -aviatorNumber.innerCompare(this, env);
            }
            case String: {
                AviatorString aviatorString = (AviatorString)other;
                return -aviatorString.innerCompare(this, env);
            }
            case Boolean: {
                AviatorBoolean aviatorBoolean = (AviatorBoolean)other;
                return -aviatorBoolean.innerCompare(this, env);
            }
            case JavaType: {
                AviatorJavaType otherJavaType = (AviatorJavaType)other;
                Object thisValue = this.getValue(env);
                Object otherValue = otherJavaType.getValue(env);
                if (thisValue == null) {
                    return AviatorNil.NIL.innerCompare(other, env);
                }
                if (thisValue.equals(otherValue)) {
                    return 0;
                }
                if (thisValue instanceof Number) {
                    AviatorNumber thisAviatorNumber = AviatorNumber.valueOf(thisValue);
                    return thisAviatorNumber.innerCompare(other, env);
                }
                if (TypeUtils.isString(thisValue)) {
                    AviatorString thisAviatorString = new AviatorString(String.valueOf(thisValue));
                    return thisAviatorString.innerCompare(other, env);
                }
                if (thisValue instanceof Boolean) {
                    AviatorBoolean thisAviatorBoolean = AviatorBoolean.valueOf((Boolean)thisValue);
                    return thisAviatorBoolean.innerCompare(other, env);
                }
                if (thisValue instanceof Date && otherValue instanceof String) {
                    return this.tryCompareDate(thisValue, otherValue);
                }
                if (otherValue == null) {
                    return 1;
                }
                try {
                    return ((Comparable)thisValue).compareTo(otherValue);
                }
                catch (ClassCastException e) {
                    throw new CompareNotSupportedException("Compare " + this.desc(env) + " with " + other.desc(env) + " error", e);
                }
            }
            case Nil: {
                if (this.getValue(env) == null) {
                    return 0;
                }
                return 1;
            }
        }
        throw new CompareNotSupportedException("Unknow aviator type");
    }

    private int tryCompareDate(Object thisValue, Object otherValue) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SS");
            Date otherDate = simpleDateFormat.parse((String)otherValue);
            return ((Date)thisValue).compareTo(otherDate);
        }
        catch (Throwable t) {
            throw new ExpressionRuntimeException("Compare date error", t);
        }
    }

    @Override
    public AviatorObject mult(AviatorObject other, Map<String, Object> env) {
        Object value = this.getValue(env);
        switch (other.getAviatorType()) {
            case BigInt: 
            case Decimal: 
            case Long: 
            case Double: {
                if (value instanceof Number) {
                    AviatorNumber aviatorNumber = AviatorNumber.valueOf(value);
                    return aviatorNumber.mult(other, env);
                }
                return super.mult(other, env);
            }
            case JavaType: {
                if (value instanceof Number) {
                    AviatorNumber thisAviatorNumber = AviatorNumber.valueOf(value);
                    return thisAviatorNumber.mult(other, env);
                }
                return super.mult(other, env);
            }
        }
        return super.mult(other, env);
    }

    @Override
    public AviatorObject neg(Map<String, Object> env) {
        Object value = this.getValue(env);
        if (value instanceof Number) {
            return AviatorNumber.valueOf(value).neg(env);
        }
        return super.neg(env);
    }

    @Override
    public AviatorObject not(Map<String, Object> env) {
        Object value = this.getValue(env);
        if (value instanceof Boolean) {
            return AviatorBoolean.valueOf((Boolean)value).not(env);
        }
        return super.not(env);
    }

    @Override
    public AviatorObject getElement(Map<String, Object> env, AviatorObject indexObject) {
        final Object thisValue = this.getValue(env);
        final Object indexValue = indexObject.getValue(env);
        if (thisValue.getClass().isArray()) {
            final int index = ((Number)indexValue).intValue();
            return new AviatorRuntimeJavaElementType(AviatorRuntimeJavaElementType.ContainerType.Array, thisValue, index, new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return Array.get(thisValue, index);
                }
            });
        }
        if (thisValue instanceof List) {
            final int index = ((Number)indexValue).intValue();
            return new AviatorRuntimeJavaElementType(AviatorRuntimeJavaElementType.ContainerType.List, thisValue, index, new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return ((List)thisValue).get(index);
                }
            });
        }
        if (thisValue instanceof Map) {
            return new AviatorRuntimeJavaElementType(AviatorRuntimeJavaElementType.ContainerType.Map, thisValue, indexValue, new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return ((Map)thisValue).get(indexValue);
                }
            });
        }
        throw new ExpressionRuntimeException(this.desc(env) + " is not an array, list or map,could not use [] to get element");
    }

    @Override
    public AviatorObject add(AviatorObject other, Map<String, Object> env) {
        Object otherValue;
        Object value = this.getValue(env);
        if (value instanceof Number) {
            AviatorNumber aviatorNumber = AviatorNumber.valueOf(value);
            return aviatorNumber.add(other, env);
        }
        if (TypeUtils.isString(value)) {
            AviatorString aviatorString = new AviatorString(String.valueOf(value));
            return aviatorString.add(other, env);
        }
        if (value instanceof Boolean) {
            return AviatorBoolean.valueOf((Boolean)value).add(other, env);
        }
        if (value == null && (otherValue = other.getValue(env)) instanceof CharSequence) {
            return new AviatorString("null" + otherValue);
        }
        return super.add(other, env);
    }

    @Override
    public String desc(Map<String, Object> env) {
        Object value = this.getValueFromEnv(this.name, this.name != null ? this.name.contains(".") : false, env, false);
        return "<" + this.getAviatorType() + ", " + this.getName() + ", " + value + ", " + (value == null ? "null" : value.getClass().getName()) + ">";
    }
}

