/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt;

import com.hivemq.client.internal.mqtt.MqttClientSslConfigImpl;
import com.hivemq.client.internal.mqtt.MqttClientTransportConfigImplBuilder;
import com.hivemq.client.internal.mqtt.MqttWebSocketConfigImpl;
import com.hivemq.client.mqtt.MqttClientSslConfig;
import com.hivemq.client.mqtt.MqttClientTransportConfig;
import com.hivemq.client.mqtt.MqttWebSocketConfig;
import java.net.InetSocketAddress;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MqttClientTransportConfigImpl
implements MqttClientTransportConfig {
    @NotNull
    public static final MqttClientTransportConfigImpl DEFAULT = new MqttClientTransportConfigImpl(InetSocketAddress.createUnresolved("localhost", 1883), null, null);
    @NotNull
    private final InetSocketAddress serverAddress;
    @Nullable
    private final MqttClientSslConfigImpl sslConfig;
    @Nullable
    private final MqttWebSocketConfigImpl webSocketConfig;

    MqttClientTransportConfigImpl(@NotNull InetSocketAddress serverAddress, @Nullable MqttClientSslConfigImpl sslConfig, @Nullable MqttWebSocketConfigImpl webSocketConfig) {
        this.serverAddress = serverAddress;
        this.sslConfig = sslConfig;
        this.webSocketConfig = webSocketConfig;
    }

    @Override
    @NotNull
    public InetSocketAddress getServerAddress() {
        return this.serverAddress;
    }

    @Override
    @NotNull
    public Optional<MqttClientSslConfig> getSslConfig() {
        return Optional.ofNullable(this.sslConfig);
    }

    @Nullable
    public MqttClientSslConfigImpl getRawSslConfig() {
        return this.sslConfig;
    }

    @Override
    @NotNull
    public Optional<MqttWebSocketConfig> getWebSocketConfig() {
        return Optional.ofNullable(this.webSocketConfig);
    }

    @Nullable
    public MqttWebSocketConfigImpl getRawWebSocketConfig() {
        return this.webSocketConfig;
    }

    @Override
    @NotNull
    public MqttClientTransportConfigImplBuilder.Default extend() {
        return new MqttClientTransportConfigImplBuilder.Default(this);
    }
}

