/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.codec.decoder.mqtt5;

import com.hivemq.client.internal.mqtt.codec.decoder.MqttDecoderContext;
import com.hivemq.client.internal.mqtt.codec.decoder.MqttDecoderException;
import com.hivemq.client.internal.mqtt.codec.decoder.MqttMessageDecoder;
import com.hivemq.client.internal.mqtt.codec.decoder.MqttMessageDecoderUtil;
import com.hivemq.client.internal.mqtt.codec.decoder.mqtt5.Mqtt5MessageDecoderUtil;
import com.hivemq.client.internal.mqtt.datatypes.MqttClientIdentifierImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertyImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUtf8StringImpl;
import com.hivemq.client.internal.mqtt.message.auth.MqttEnhancedAuth;
import com.hivemq.client.internal.mqtt.message.connect.connack.MqttConnAck;
import com.hivemq.client.internal.mqtt.message.connect.connack.MqttConnAckRestrictions;
import com.hivemq.client.internal.util.collections.ImmutableList;
import com.hivemq.client.mqtt.datatypes.MqttQos;
import com.hivemq.client.mqtt.mqtt5.message.connect.connack.Mqtt5ConnAckReasonCode;
import com.hivemq.client.mqtt.mqtt5.message.connect.connack.Mqtt5ConnAckRestrictions;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5DisconnectReasonCode;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;

@Singleton
public class Mqtt5ConnAckDecoder
implements MqttMessageDecoder {
    private static final int FLAGS = 0;
    private static final int MIN_REMAINING_LENGTH = 3;

    @Inject
    Mqtt5ConnAckDecoder() {
    }

    @Override
    @NotNull
    public MqttConnAck decode(int flags, @NotNull ByteBuf in, @NotNull MqttDecoderContext context) throws MqttDecoderException {
        MqttMessageDecoderUtil.checkFixedHeaderFlags(0, flags);
        if (in.readableBytes() < 3) {
            throw MqttMessageDecoderUtil.remainingLengthTooShort();
        }
        short connAckFlags = in.readUnsignedByte();
        if ((connAckFlags & 0xFE) != 0) {
            throw new MqttDecoderException("wrong CONNACK flags, bits 7-1 must be 0");
        }
        boolean sessionPresent = (connAckFlags & 1) != 0;
        Mqtt5ConnAckReasonCode reasonCode = Mqtt5ConnAckReasonCode.fromCode(in.readUnsignedByte());
        if (reasonCode == null) {
            throw Mqtt5MessageDecoderUtil.wrongReasonCode();
        }
        if (reasonCode != Mqtt5ConnAckReasonCode.SUCCESS && sessionPresent) {
            throw new MqttDecoderException("session present must be 0 if reason code is not SUCCESS");
        }
        Mqtt5MessageDecoderUtil.checkPropertyLengthNoPayload(in);
        long sessionExpiryInterval = -1L;
        MqttClientIdentifierImpl assignedClientIdentifier = null;
        int serverKeepAlive = -1;
        MqttUtf8StringImpl authMethod = null;
        ByteBuffer authData = null;
        int receiveMaximum = 65535;
        boolean receiveMaximumPresent = false;
        int topicAliasMaximum = 0;
        boolean topicAliasMaximumPresent = false;
        MqttQos maximumQos = Mqtt5ConnAckRestrictions.DEFAULT_MAXIMUM_QOS;
        boolean maximumQosPresent = false;
        boolean retainAvailable = true;
        boolean retainAvailablePresent = false;
        int maximumPacketSize = 0x10000004;
        boolean maximumPacketSizePresent = false;
        boolean wildCardSubscriptionAvailable = true;
        boolean wildCardSubscriptionAvailablePresent = false;
        boolean subscriptionIdentifiersAvailable = true;
        boolean subscriptionIdentifiersAvailablePresent = false;
        boolean sharedSubscriptionAvailable = true;
        boolean sharedSubscriptionAvailablePresent = false;
        MqttUtf8StringImpl responseInformation = null;
        MqttUtf8StringImpl serverReference = null;
        MqttUtf8StringImpl reasonString = null;
        ImmutableList.Builder<MqttUserPropertyImpl> userPropertiesBuilder = null;
        boolean restrictionsPresent = false;
        block19: while (in.isReadable()) {
            int propertyIdentifier = Mqtt5MessageDecoderUtil.decodePropertyIdentifier(in);
            switch (propertyIdentifier) {
                case 17: {
                    sessionExpiryInterval = Mqtt5MessageDecoderUtil.decodeSessionExpiryInterval(sessionExpiryInterval, in);
                    continue block19;
                }
                case 18: {
                    if (assignedClientIdentifier != null) {
                        throw Mqtt5MessageDecoderUtil.moreThanOnce("client identifier");
                    }
                    assignedClientIdentifier = MqttClientIdentifierImpl.decode(in);
                    if (assignedClientIdentifier != null) continue block19;
                    throw MqttMessageDecoderUtil.malformedUTF8String("client identifier");
                }
                case 19: {
                    serverKeepAlive = Mqtt5MessageDecoderUtil.unsignedShortOnlyOnce(serverKeepAlive, -1, "server keep alive", in);
                    continue block19;
                }
                case 21: {
                    authMethod = Mqtt5MessageDecoderUtil.decodeAuthMethod(authMethod, in);
                    continue block19;
                }
                case 22: {
                    authData = Mqtt5MessageDecoderUtil.decodeAuthData(authData, in, context);
                    continue block19;
                }
                case 33: {
                    receiveMaximum = Mqtt5MessageDecoderUtil.unsignedShortOnlyOnce(receiveMaximumPresent, "receive maximum", in);
                    if (receiveMaximum == 0) {
                        throw new MqttDecoderException(Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "receive maximum must not be 0");
                    }
                    receiveMaximumPresent = true;
                    restrictionsPresent |= receiveMaximum != 65535;
                    continue block19;
                }
                case 34: {
                    topicAliasMaximum = Mqtt5MessageDecoderUtil.unsignedShortOnlyOnce(topicAliasMaximumPresent, "receive maximum", in);
                    topicAliasMaximumPresent = true;
                    restrictionsPresent |= topicAliasMaximum != 0;
                    continue block19;
                }
                case 36: {
                    short maximumQosCode = Mqtt5MessageDecoderUtil.unsignedByteOnlyOnce(maximumQosPresent, "maximum Qos", in);
                    if (maximumQosCode != 0 && maximumQosCode != 1) {
                        throw new MqttDecoderException(Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "wrong maximum Qos");
                    }
                    maximumQos = MqttQos.fromCode(maximumQosCode);
                    assert (maximumQos != null);
                    maximumQosPresent = true;
                    restrictionsPresent |= maximumQos != Mqtt5ConnAckRestrictions.DEFAULT_MAXIMUM_QOS;
                    continue block19;
                }
                case 37: {
                    retainAvailable = Mqtt5MessageDecoderUtil.booleanOnlyOnce(retainAvailablePresent, "retain available", in);
                    retainAvailablePresent = true;
                    restrictionsPresent |= !retainAvailable;
                    continue block19;
                }
                case 39: {
                    long maximumPacketSizeTemp = Mqtt5MessageDecoderUtil.unsignedIntOnlyOnce(maximumPacketSizePresent, "maximum packet size", in);
                    if (maximumPacketSizeTemp == 0L) {
                        throw new MqttDecoderException(Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "maximum packet size must not be 0");
                    }
                    maximumPacketSizePresent = true;
                    if (maximumPacketSizeTemp >= 0x10000004L) continue block19;
                    maximumPacketSize = (int)maximumPacketSizeTemp;
                    restrictionsPresent = true;
                    continue block19;
                }
                case 40: {
                    wildCardSubscriptionAvailable = Mqtt5MessageDecoderUtil.booleanOnlyOnce(wildCardSubscriptionAvailablePresent, "wildcard subscription available", in);
                    wildCardSubscriptionAvailablePresent = true;
                    restrictionsPresent |= !wildCardSubscriptionAvailable;
                    continue block19;
                }
                case 41: {
                    subscriptionIdentifiersAvailable = Mqtt5MessageDecoderUtil.booleanOnlyOnce(subscriptionIdentifiersAvailablePresent, "subscription identifier available", in);
                    subscriptionIdentifiersAvailablePresent = true;
                    restrictionsPresent |= !subscriptionIdentifiersAvailable;
                    continue block19;
                }
                case 42: {
                    sharedSubscriptionAvailable = Mqtt5MessageDecoderUtil.booleanOnlyOnce(sharedSubscriptionAvailablePresent, "shared subscription available", in);
                    sharedSubscriptionAvailablePresent = true;
                    restrictionsPresent |= !sharedSubscriptionAvailable;
                    continue block19;
                }
                case 26: {
                    if (!context.isResponseInformationRequested()) {
                        throw new MqttDecoderException(Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "response information must not be included if it was not requested");
                    }
                    responseInformation = Mqtt5MessageDecoderUtil.decodeUTF8StringOnlyOnce(responseInformation, "response information", in);
                    continue block19;
                }
                case 28: {
                    serverReference = Mqtt5MessageDecoderUtil.decodeServerReference(serverReference, in);
                    continue block19;
                }
                case 31: {
                    reasonString = Mqtt5MessageDecoderUtil.decodeReasonString(reasonString, in);
                    continue block19;
                }
                case 38: {
                    userPropertiesBuilder = Mqtt5MessageDecoderUtil.decodeUserProperty(userPropertiesBuilder, in);
                    continue block19;
                }
            }
            throw Mqtt5MessageDecoderUtil.wrongProperty(propertyIdentifier);
        }
        MqttEnhancedAuth enhancedAuth = null;
        if (authMethod != null) {
            enhancedAuth = new MqttEnhancedAuth(authMethod, authData);
        } else if (authData != null) {
            throw new MqttDecoderException(Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "auth data must not be included if auth method is absent");
        }
        MqttConnAckRestrictions restrictions = MqttConnAckRestrictions.DEFAULT;
        if (restrictionsPresent) {
            restrictions = new MqttConnAckRestrictions(receiveMaximum, maximumPacketSize, topicAliasMaximum, maximumQos, retainAvailable, wildCardSubscriptionAvailable, sharedSubscriptionAvailable, subscriptionIdentifiersAvailable);
        }
        MqttUserPropertiesImpl userProperties = MqttUserPropertiesImpl.build(userPropertiesBuilder);
        return new MqttConnAck(reasonCode, sessionPresent, sessionExpiryInterval, serverKeepAlive, assignedClientIdentifier, enhancedAuth, restrictions, responseInformation, serverReference, reasonString, userProperties);
    }
}

