/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.datatypes;

import com.hivemq.client.annotations.Immutable;
import com.hivemq.client.internal.mqtt.datatypes.MqttBinaryData;
import com.hivemq.client.internal.mqtt.datatypes.MqttSharedTopicFilterImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicFilterImplBuilder;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUtf8StringImpl;
import com.hivemq.client.internal.mqtt.util.MqttChecks;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.internal.util.collections.ImmutableList;
import com.hivemq.client.mqtt.datatypes.MqttTopic;
import com.hivemq.client.mqtt.datatypes.MqttTopicFilter;
import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public class MqttTopicFilterImpl
extends MqttUtf8StringImpl
implements MqttTopicFilter {
    static final int WILDCARD_CHECK_FAILURE = -1;
    private static final int WILDCARD_FLAG_MULTI_LEVEL = 1;
    private static final int WILDCARD_FLAG_SINGLE_LEVEL = 2;
    private static final int WILDCARD_CHECK_STATE_NOT_BEFORE = 0;
    private static final int WILDCARD_CHECK_STATE_BEFORE = 1;
    private static final int WILDCARD_CHECK_STATE_MULTI_LEVEL = 2;
    private static final int WILDCARD_CHECK_STATE_SINGLE_LEVEL = 3;
    final int wildcardFlags;

    @Contract(value="null -> fail")
    @NotNull
    public static MqttTopicFilterImpl of(@Nullable String string) {
        Checks.notEmpty(string, "Topic filter");
        MqttTopicFilterImpl.checkLength(string, "Topic filter");
        MqttTopicFilterImpl.checkWellFormed(string, "Topic filter");
        if (MqttSharedTopicFilterImpl.isShared(string)) {
            return MqttSharedTopicFilterImpl.ofInternal(string);
        }
        int wildcardFlags = MqttTopicFilterImpl.validateWildcards(string, 0);
        return new MqttTopicFilterImpl(string, wildcardFlags);
    }

    @NotNull
    public static MqttTopicFilterImpl of(@NotNull MqttTopicImpl topic) {
        return new MqttTopicFilterImpl(topic.toString(), 0);
    }

    @NotNull
    public static MqttTopicFilterImpl of(@NotNull MqttSharedTopicFilterImpl sharedTopicFilter) {
        return new MqttTopicFilterImpl(sharedTopicFilter.getTopicFilterString(), sharedTopicFilter.wildcardFlags);
    }

    @Nullable
    public static MqttTopicFilterImpl of(@NotNull byte[] binary) {
        if (binary.length == 0 || !MqttBinaryData.isInRange(binary) || MqttTopicFilterImpl.isWellFormed(binary)) {
            return null;
        }
        if (MqttSharedTopicFilterImpl.isShared(binary)) {
            return MqttSharedTopicFilterImpl.ofInternal(binary);
        }
        int wildcardFlags = MqttTopicFilterImpl.validateWildcards(binary, 0);
        if (wildcardFlags == -1) {
            return null;
        }
        return new MqttTopicFilterImpl(binary, wildcardFlags);
    }

    @Nullable
    public static MqttTopicFilterImpl decode(@NotNull ByteBuf byteBuf) {
        byte[] binary = MqttBinaryData.decode(byteBuf);
        return binary == null ? null : MqttTopicFilterImpl.of(binary);
    }

    static int validateWildcards(@NotNull byte[] binary, int start) {
        int wildcardFlags = 0;
        int state = 1;
        block11: for (int i = start; i < binary.length; ++i) {
            byte b = binary[i];
            switch (state) {
                case 0: {
                    if (b == 43 || b == 35) {
                        return -1;
                    }
                    if (b != 47) continue block11;
                    state = 1;
                    continue block11;
                }
                case 1: {
                    switch (b) {
                        case 35: {
                            wildcardFlags |= 1;
                            state = 2;
                            continue block11;
                        }
                        case 43: {
                            wildcardFlags |= 2;
                            state = 3;
                            continue block11;
                        }
                        case 47: {
                            state = 1;
                            continue block11;
                        }
                    }
                    state = 0;
                    continue block11;
                }
                case 2: {
                    return -1;
                }
                case 3: {
                    if (b != 47) {
                        return -1;
                    }
                    state = 1;
                }
            }
        }
        return wildcardFlags;
    }

    static int validateWildcards(@NotNull String string, int start) {
        int wildcardFlags = 0;
        int state = 1;
        block11: for (int i = start; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (state) {
                case 0: {
                    if (c == '+' || c == '#') {
                        throw new IllegalArgumentException("Topic filter [" + string.substring(start) + "] contains misplaced wildcard characters. Wildcard (" + c + ") at index " + (i - start) + " must follow a topic level separator.");
                    }
                    if (c != '/') continue block11;
                    state = 1;
                    continue block11;
                }
                case 1: {
                    switch (c) {
                        case '#': {
                            wildcardFlags |= 1;
                            state = 2;
                            continue block11;
                        }
                        case '+': {
                            wildcardFlags |= 2;
                            state = 3;
                            continue block11;
                        }
                        case '/': {
                            state = 1;
                            continue block11;
                        }
                    }
                    state = 0;
                    continue block11;
                }
                case 2: {
                    throw new IllegalArgumentException("Topic filter [" + string.substring(start) + "] contains misplaced wildcard characters. Multi level wildcard (" + '#' + ") must be the last character.");
                }
                case 3: {
                    if (c != '/') {
                        throw new IllegalArgumentException("Topic filter [" + string.substring(start) + "] contains misplaced wildcard characters. Single level wildcard (" + '+' + ") at index " + (i - start - 1) + " must be followed by a topic level separator.");
                    }
                    state = 1;
                }
            }
        }
        return wildcardFlags;
    }

    MqttTopicFilterImpl(@NotNull byte[] binary, int wildcardFlags) {
        super(binary);
        this.wildcardFlags = wildcardFlags;
    }

    MqttTopicFilterImpl(@NotNull String string, int wildcardFlags) {
        super(string);
        this.wildcardFlags = wildcardFlags;
    }

    @NotNull
    public ImmutableList<String> getLevels() {
        return MqttTopicImpl.splitLevels(this.getTopicFilterString());
    }

    @Override
    public boolean containsWildcards() {
        return this.wildcardFlags != 0;
    }

    @Override
    public boolean containsMultiLevelWildcard() {
        return (this.wildcardFlags & 1) != 0;
    }

    @Override
    public boolean containsSingleLevelWildcard() {
        return (this.wildcardFlags & 2) != 0;
    }

    @Override
    public boolean isShared() {
        return false;
    }

    @Override
    @NotNull
    public MqttSharedTopicFilterImpl share(@Nullable String shareName) {
        return MqttSharedTopicFilterImpl.of(shareName, this);
    }

    int getFilterByteStart() {
        return 0;
    }

    @NotNull
    public String getTopicFilterString() {
        return this.toString();
    }

    @Override
    public boolean matches(@Nullable MqttTopic topic) {
        return this.matches(MqttChecks.topic(topic));
    }

    public boolean matches(@NotNull MqttTopicImpl topic) {
        return MqttTopicFilterImpl.matches(this.toBinary(), this.getFilterByteStart(), topic.toBinary());
    }

    private static boolean matches(@NotNull byte[] filter, int offset, @NotNull byte[] topic) {
        int fi = offset;
        int ti = 0;
        while (fi < filter.length) {
            byte fb;
            if ((fb = filter[fi++]) == 35) {
                return true;
            }
            if (fb == 43) {
                while (ti < topic.length && topic[ti] != 47) {
                    ++ti;
                }
                continue;
            }
            if (ti == topic.length) {
                return fb == 47 && fi + 1 == filter.length && filter[fi] == 35;
            }
            if (topic[ti++] == fb) continue;
            return false;
        }
        return fi == filter.length && ti == topic.length;
    }

    @Override
    public boolean matches(@Nullable MqttTopicFilter topicFilter) {
        return this.matches(MqttChecks.topicFilter(topicFilter));
    }

    public boolean matches(@NotNull MqttTopicFilterImpl topicFilter) {
        return MqttTopicFilterImpl.matches(this.toBinary(), this.getFilterByteStart(), topicFilter.toBinary(), topicFilter.getFilterByteStart());
    }

    private static boolean matches(@NotNull byte[] filter1, int offset1, @NotNull byte[] filter2, int offset2) {
        int i1 = offset1;
        int i2 = offset2;
        while (i1 < filter1.length) {
            byte b1;
            if ((b1 = filter1[i1++]) == 35) {
                return true;
            }
            if (b1 == 43) {
                if (filter2[i2] == 35) {
                    return false;
                }
                while (i2 < filter2.length && filter2[i2] != 47) {
                    ++i2;
                }
                continue;
            }
            if (i2 == filter2.length) {
                return b1 == 47 && i1 + 1 == filter1.length && filter1[i1] == 35;
            }
            if (filter2[i2++] == b1) continue;
            return false;
        }
        return i1 == filter1.length && i2 == filter2.length;
    }

    @Override
    @NotNull
    public MqttTopicFilterImplBuilder.Default extend() {
        return new MqttTopicFilterImplBuilder.Default(this);
    }
}

