/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler;

import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.MqttClientSslConfigImpl;
import com.hivemq.client.internal.mqtt.MqttClientTransportConfigImpl;
import com.hivemq.client.internal.mqtt.MqttWebSocketConfigImpl;
import com.hivemq.client.internal.mqtt.codec.encoder.MqttEncoder;
import com.hivemq.client.internal.mqtt.handler.auth.MqttAuthHandler;
import com.hivemq.client.internal.mqtt.handler.connect.MqttConnAckFlow;
import com.hivemq.client.internal.mqtt.handler.connect.MqttConnAckSingle;
import com.hivemq.client.internal.mqtt.handler.connect.MqttConnectHandler;
import com.hivemq.client.internal.mqtt.handler.disconnect.MqttDisconnectHandler;
import com.hivemq.client.internal.mqtt.handler.ssl.SslUtil;
import com.hivemq.client.internal.mqtt.handler.websocket.MqttWebSocketInitializer;
import com.hivemq.client.internal.mqtt.ioc.ConnectionScope;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnect;
import com.hivemq.client.mqtt.exceptions.ConnectionFailedException;
import com.hivemq.client.mqtt.lifecycle.MqttDisconnectSource;
import dagger.Lazy;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import java.net.URISyntaxException;
import javax.inject.Inject;
import javax.net.ssl.SSLException;
import org.jetbrains.annotations.NotNull;

@ConnectionScope
public class MqttChannelInitializer
extends ChannelInitializer<Channel> {
    @NotNull
    private final MqttClientConfig clientConfig;
    @NotNull
    private final MqttConnect connect;
    @NotNull
    private final MqttConnAckFlow connAckFlow;
    @NotNull
    private final MqttEncoder encoder;
    @NotNull
    private final MqttConnectHandler connectHandler;
    @NotNull
    private final MqttDisconnectHandler disconnectHandler;
    @NotNull
    private final MqttAuthHandler authHandler;
    @NotNull
    private final Lazy<MqttWebSocketInitializer> webSocketInitializer;

    @Inject
    MqttChannelInitializer(@NotNull MqttClientConfig clientConfig, @NotNull MqttConnect connect, @NotNull MqttConnAckFlow connAckFlow, @NotNull MqttEncoder encoder, @NotNull MqttConnectHandler connectHandler, @NotNull MqttDisconnectHandler disconnectHandler, @NotNull MqttAuthHandler authHandler, @NotNull Lazy<MqttWebSocketInitializer> webSocketInitializer) {
        this.clientConfig = clientConfig;
        this.connect = connect;
        this.connAckFlow = connAckFlow;
        this.encoder = encoder;
        this.connectHandler = connectHandler;
        this.disconnectHandler = disconnectHandler;
        this.authHandler = authHandler;
        this.webSocketInitializer = webSocketInitializer;
    }

    protected void initChannel(@NotNull Channel channel) throws Exception {
        MqttWebSocketConfigImpl webSocketConfig;
        MqttClientTransportConfigImpl transportConfig = this.connAckFlow.getTransportConfig();
        MqttClientSslConfigImpl sslConfig = transportConfig.getRawSslConfig();
        if (sslConfig != null) {
            this.initSsl(channel, sslConfig);
        }
        if ((webSocketConfig = transportConfig.getRawWebSocketConfig()) != null) {
            this.initWebSocketMqtt(channel, webSocketConfig);
        } else {
            this.initMqtt(channel);
        }
    }

    public void initMqtt(@NotNull Channel channel) {
        channel.pipeline().addLast("encoder", (ChannelHandler)this.encoder).addLast("auth", (ChannelHandler)this.authHandler).addLast("connect", (ChannelHandler)this.connectHandler).addLast("disconnect", (ChannelHandler)this.disconnectHandler);
    }

    private void initWebSocketMqtt(@NotNull Channel channel, @NotNull MqttWebSocketConfigImpl webSocketConfig) throws URISyntaxException {
        ((MqttWebSocketInitializer)((Object)this.webSocketInitializer.get())).initChannel(channel, webSocketConfig);
    }

    private void initSsl(@NotNull Channel channel, @NotNull MqttClientSslConfigImpl sslConfig) throws SSLException {
        SslUtil.initChannel(channel, sslConfig);
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        if (ctx.pipeline().get("disconnect") != null) {
            ctx.pipeline().remove("disconnect");
        }
        ctx.close();
        MqttConnAckSingle.reconnect(this.clientConfig, MqttDisconnectSource.CLIENT, (Throwable)new ConnectionFailedException(cause), this.connect, this.connAckFlow, ctx.channel().eventLoop());
        this.clientConfig.releaseEventLoop();
    }
}

