/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.publish.outgoing;

import com.hivemq.client.internal.mqtt.datatypes.MqttTopicImpl;
import com.hivemq.client.internal.mqtt.handler.publish.outgoing.MqttTopicAliasMapping;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MqttTopicAliasAutoMapping
implements MqttTopicAliasMapping {
    private static final byte OVERSIZE = 8;
    private static final byte RETAIN = 10;
    private static final byte OVERWRITE_TRIES = 3;
    private final int topicAliasMaximum;
    @NotNull
    private final Map<String, Entry> map = new HashMap<String, Entry>();
    @Nullable
    private Entry lowest;
    private long accessCounter;
    private byte overwriteTries;
    private byte fullOverwriteTries;

    public MqttTopicAliasAutoMapping(int topicAliasMaximum) {
        this.topicAliasMaximum = topicAliasMaximum;
    }

    @Override
    public int getTopicAliasMaximum() {
        return this.topicAliasMaximum;
    }

    @Override
    public int onPublish(@NotNull MqttTopicImpl topic) {
        ++this.accessCounter;
        String topicString = topic.toString();
        Entry entry = this.map.get(topicString);
        if (entry != null) {
            long priority = entry.access(this.accessCounter);
            if (entry.topicAlias != 0 && entry.lower != null && entry.lower.topicAlias == 0) {
                if (this.overwriteTries > 0) {
                    this.overwriteTries = (byte)(this.overwriteTries - 1);
                }
            } else if (entry == this.lowest && this.fullOverwriteTries > 0) {
                this.fullOverwriteTries = (byte)(this.fullOverwriteTries - 1);
            }
            this.swapNewer(entry, priority);
            return entry.topicAlias;
        }
        if (this.map.size() < this.topicAliasMaximum + 8) {
            Entry newEntry = new Entry(this.accessCounter);
            if (this.map.size() < this.topicAliasMaximum) {
                newEntry.setNewTopicAlias(this.map.size() + 1);
            }
            this.map.put(topicString, newEntry);
            if (this.lowest != null) {
                newEntry.higher = this.lowest;
                this.lowest.lower = newEntry;
            }
            this.lowest = newEntry;
            this.swapNewer(newEntry, newEntry.priority());
            return newEntry.topicAlias;
        }
        this.fullOverwriteTries = (byte)(this.fullOverwriteTries + 1);
        if (this.fullOverwriteTries < 3) {
            return 0;
        }
        this.fullOverwriteTries = 0;
        this.map.values().remove(this.lowest);
        Entry newEntry = new Entry(this.accessCounter);
        this.map.put(topicString, newEntry);
        if (this.lowest != null) {
            Entry higher;
            newEntry.topicAlias = this.lowest.topicAlias;
            newEntry.higher = higher = this.lowest.higher;
            if (higher != null) {
                higher.lower = newEntry;
            }
        }
        this.lowest = newEntry;
        return newEntry.topicAlias;
    }

    private void swapNewer(@NotNull Entry entry, long priority) {
        long newerPriority;
        Entry higher;
        while ((higher = entry.higher) != null && (newerPriority = higher.priority(this.accessCounter)) < priority) {
            if (entry.topicAlias == 0 && higher.topicAlias != 0) {
                this.overwriteTries = (byte)(this.overwriteTries + 1);
                if (this.overwriteTries < 3) break;
                this.overwriteTries = 0;
                entry.setNewTopicAlias(higher.topicAlias);
                higher.topicAlias = 0;
            }
            higher.lower = entry.lower;
            entry.higher = higher.higher;
            entry.lower = higher;
            higher.higher = entry;
            if (entry != this.lowest) continue;
            this.lowest = higher;
        }
    }

    @NotNull
    public String toString() {
        TreeSet<Map.Entry<String, Entry>> sorted = new TreeSet<Map.Entry<String, Entry>>((o1, o2) -> {
            Entry entry = ((Entry)o1.getValue()).higher;
            while (entry != null) {
                if (entry == o2.getValue()) {
                    return 1;
                }
                entry = entry.higher;
            }
            return -1;
        });
        sorted.addAll(this.map.entrySet());
        StringBuilder s = new StringBuilder();
        for (Map.Entry entry : sorted) {
            s.append(" -> ").append(entry.toString());
        }
        return s.toString();
    }

    static class Entry {
        int topicAlias = 0;
        long used = 1L;
        long access;
        @Nullable
        Entry higher;
        @Nullable
        Entry lower;

        Entry(long accessCounter) {
            this.access = accessCounter;
        }

        void setNewTopicAlias(int topicAlias) {
            this.topicAlias = topicAlias | 0x10000;
        }

        long access(long accessCounter) {
            this.update(accessCounter);
            this.topicAlias &= 0xFFFF;
            ++this.used;
            this.access = accessCounter;
            return this.priority();
        }

        long priority(long accessCounter) {
            this.update(accessCounter);
            return this.priority();
        }

        long priority() {
            return this.used + this.access;
        }

        private void update(long accessCounter) {
            long decay = Math.max(accessCounter - this.access - 10L, 0L);
            this.used = Math.max(this.used - decay, 1L);
        }

        @NotNull
        public String toString() {
            int topicAlias = this.topicAlias & 0xFFFF;
            return (topicAlias == 0 ? "-" : Integer.valueOf(topicAlias)) + " (used: " + this.used + ", access: " + this.access + ")";
        }
    }
}

