/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.lifecycle;

import com.hivemq.client.internal.mqtt.MqttClientTransportConfigImpl;
import com.hivemq.client.internal.mqtt.MqttClientTransportConfigImplBuilder;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnect;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnectBuilder;
import com.hivemq.client.internal.mqtt.util.MqttChecks;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.mqtt.MqttClientTransportConfig;
import com.hivemq.client.mqtt.mqtt5.lifecycle.Mqtt5ClientReconnector;
import com.hivemq.client.mqtt.mqtt5.message.connect.Mqtt5Connect;
import io.netty.channel.EventLoop;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MqttClientReconnector
implements Mqtt5ClientReconnector {
    @NotNull
    private final EventLoop eventLoop;
    private final int attempts;
    private boolean reconnect;
    @Nullable
    private CompletableFuture<?> future;
    private long delayNanos;
    @NotNull
    private MqttClientTransportConfigImpl transportConfig;
    @NotNull
    private MqttConnect connect;

    public MqttClientReconnector(@NotNull EventLoop eventLoop, int attempts, @NotNull MqttConnect connect, @NotNull MqttClientTransportConfigImpl transportConfig) {
        this.eventLoop = eventLoop;
        this.attempts = attempts;
        this.connect = connect;
        this.transportConfig = transportConfig;
    }

    @Override
    public int getAttempts() {
        this.checkThread();
        return this.attempts;
    }

    @Override
    @NotNull
    public MqttClientReconnector reconnect(boolean reconnect) {
        this.checkThread();
        this.reconnect = reconnect;
        return this;
    }

    @Override
    @NotNull
    public <T> Mqtt5ClientReconnector reconnectWhen(@Nullable CompletableFuture<T> future, @Nullable BiConsumer<? super T, ? super Throwable> callback) {
        this.checkThread();
        Checks.notNull(future, "Future");
        this.reconnect = true;
        if (callback != null) {
            future = future.whenCompleteAsync(callback, (Executor)this.eventLoop);
        }
        this.future = this.future == null ? future : CompletableFuture.allOf(new CompletableFuture[]{this.future, future});
        return this;
    }

    @Override
    public boolean isReconnect() {
        this.checkThread();
        return this.reconnect;
    }

    @NotNull
    public CompletableFuture<?> getFuture() {
        this.checkThread();
        return this.future == null ? CompletableFuture.completedFuture(null) : this.future;
    }

    @Override
    @NotNull
    public MqttClientReconnector delay(long delay, @Nullable TimeUnit timeUnit) {
        this.checkThread();
        Checks.notNull(timeUnit, "Time unit");
        this.delayNanos = timeUnit.toNanos(delay);
        return this;
    }

    @Override
    public long getDelay(@NotNull TimeUnit timeUnit) {
        this.checkThread();
        Checks.notNull(timeUnit, "Time unit");
        return timeUnit.convert(this.delayNanos, TimeUnit.NANOSECONDS);
    }

    @Override
    @NotNull
    public MqttClientReconnector transportConfig(@Nullable MqttClientTransportConfig transportConfig) {
        this.checkThread();
        this.transportConfig = Checks.notImplemented(transportConfig, MqttClientTransportConfigImpl.class, "Transport config");
        return this;
    }

    @NotNull
    public MqttClientTransportConfigImplBuilder.Nested<MqttClientReconnector> transportConfig() {
        this.checkThread();
        return new MqttClientTransportConfigImplBuilder.Nested<MqttClientReconnector>(this.transportConfig, this::transportConfig);
    }

    @Override
    @NotNull
    public MqttClientTransportConfigImpl getTransportConfig() {
        this.checkThread();
        return this.transportConfig;
    }

    @Override
    @NotNull
    public MqttClientReconnector connect(@Nullable Mqtt5Connect connect) {
        this.checkThread();
        this.connect = MqttChecks.connect(connect);
        return this;
    }

    @NotNull
    public MqttConnectBuilder.Nested<MqttClientReconnector> connectWith() {
        this.checkThread();
        return new MqttConnectBuilder.Nested<MqttClientReconnector>(this.connect, this::connect);
    }

    @Override
    @NotNull
    public MqttConnect getConnect() {
        this.checkThread();
        return this.connect;
    }

    private void checkThread() {
        if (!this.eventLoop.inEventLoop()) {
            throw new IllegalStateException("MqttClientReconnector must be called from the eventLoop.");
        }
    }
}

