/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.auth;

import com.hivemq.client.internal.mqtt.datatypes.MqttUtf8StringImpl;
import com.hivemq.client.internal.mqtt.message.auth.MqttEnhancedAuth;
import com.hivemq.client.internal.mqtt.util.MqttChecks;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.mqtt.mqtt5.message.auth.Mqtt5EnhancedAuthBuilder;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MqttEnhancedAuthBuilder
implements Mqtt5EnhancedAuthBuilder {
    @NotNull
    private final MqttUtf8StringImpl method;
    @Nullable
    private ByteBuffer data;

    public MqttEnhancedAuthBuilder(@NotNull MqttUtf8StringImpl method) {
        Checks.notNull(method, "Method");
        this.method = method;
    }

    @Override
    @NotNull
    public MqttEnhancedAuthBuilder data(@Nullable byte[] data) {
        this.data = MqttChecks.binaryDataOrNull(data, "Auth data");
        return this;
    }

    @Override
    @NotNull
    public MqttEnhancedAuthBuilder data(@Nullable ByteBuffer data) {
        this.data = MqttChecks.binaryDataOrNull(data, "Auth data");
        return this;
    }

    @NotNull
    public MqttEnhancedAuth build() {
        return new MqttEnhancedAuth(this.method, this.data);
    }
}

