/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.rx.operators;

import com.hivemq.client.internal.rx.WithSingleConditionalSubscriber;
import com.hivemq.client.internal.rx.operators.FlowableWithSingleOperator;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.rx.FlowableWithSingle;
import com.hivemq.client.rx.FlowableWithSingleSubscriber;
import com.hivemq.client.rx.reactivestreams.WithSingleSubscriber;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.fuseable.ConditionalSubscriber;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class FlowableWithSingleMap<F, S, FM, SM>
extends FlowableWithSingleOperator<F, S, FM, SM> {
    @Nullable
    private final Function<? super F, ? extends FM> flowableMapper;
    @NotNull
    private final Function<? super S, ? extends SM> singleMapper;

    @NotNull
    public static <FU, SU, F, S> FlowableWithSingleMap<FU, SU, F, S> mapBoth(@NotNull FlowableWithSingle<FU, SU> source, @Nullable Function<? super FU, ? extends F> flowableMapper, @NotNull Function<? super SU, ? extends S> singleMapper) {
        return new FlowableWithSingleMap<FU, SU, F, S>(source, flowableMapper, singleMapper);
    }

    @NotNull
    public static <FU, SU, S> FlowableWithSingleMap<FU, SU, FU, S> mapSingle(@NotNull FlowableWithSingle<FU, SU> source, @NotNull Function<? super SU, ? extends S> singleMapper) {
        return new FlowableWithSingleMap(source, null, singleMapper);
    }

    private FlowableWithSingleMap(@NotNull FlowableWithSingle<F, S> source, @Nullable Function<? super F, ? extends FM> flowableMapper, @NotNull Function<? super S, ? extends SM> singleMapper) {
        super(source);
        this.flowableMapper = flowableMapper;
        this.singleMapper = singleMapper;
    }

    protected void subscribeActual(@NotNull Subscriber<? super FM> subscriber) {
        if (subscriber instanceof ConditionalSubscriber) {
            ConditionalSubscriber conditional = (ConditionalSubscriber)subscriber;
            this.source.subscribeBoth(new MapSubscriber.Conditional<F, S, FM, SM, ConditionalSubscriber>(conditional, this.flowableMapper, this.singleMapper));
        } else {
            this.source.subscribeBoth(new MapSubscriber<F, S, FM, SM, Subscriber<? super FM>>(subscriber, this.flowableMapper, this.singleMapper));
        }
    }

    @Override
    protected void subscribeBothActual(@NotNull WithSingleSubscriber<? super FM, ? super SM> subscriber) {
        if (subscriber instanceof WithSingleConditionalSubscriber) {
            WithSingleConditionalSubscriber conditional = (WithSingleConditionalSubscriber)subscriber;
            this.source.subscribeBoth(new WithSingleMapSubscriber.Conditional<F, S, FM, SM>(conditional, this.flowableMapper, this.singleMapper));
        } else {
            this.source.subscribeBoth(new WithSingleMapSubscriber<F, S, FM, SM>(subscriber, this.flowableMapper, this.singleMapper));
        }
    }

    private static class WithSingleMapSubscriber<F, S, FM, SM>
    extends MapSubscriber<F, S, FM, SM, WithSingleSubscriber<? super FM, ? super SM>> {
        WithSingleMapSubscriber(@NotNull WithSingleSubscriber<? super FM, ? super SM> subscriber, @Nullable Function<? super F, ? extends FM> flowableMapper, @NotNull Function<? super S, ? extends SM> singleMapper) {
            super(subscriber, flowableMapper, singleMapper);
        }

        @Override
        void onSingleMapped(@NotNull SM sm) {
            ((WithSingleSubscriber)this.subscriber).onSingle(sm);
        }

        private static class Conditional<F, S, FM, SM>
        extends MapSubscriber.Conditional<F, S, FM, SM, WithSingleConditionalSubscriber<? super FM, ? super SM>> {
            Conditional(@NotNull WithSingleConditionalSubscriber<? super FM, ? super SM> subscriber, @Nullable Function<? super F, ? extends FM> flowableMapper, @NotNull Function<? super S, ? extends SM> singleMapper) {
                super(subscriber, flowableMapper, singleMapper);
            }

            @Override
            void onSingleMapped(@NotNull SM sm) {
                ((WithSingleConditionalSubscriber)this.subscriber).onSingle(sm);
            }
        }
    }

    private static class MapSubscriber<F, S, FM, SM, T extends Subscriber<? super FM>>
    implements FlowableWithSingleSubscriber<F, S>,
    Subscription {
        @NotNull
        final T subscriber;
        @Nullable
        final Function<? super F, ? extends FM> flowableMapper;
        @NotNull
        private final Function<? super S, ? extends SM> singleMapper;
        @Nullable
        private Subscription subscription;

        MapSubscriber(@NotNull T subscriber, @Nullable Function<? super F, ? extends FM> flowableMapper, @NotNull Function<? super S, ? extends SM> singleMapper) {
            this.subscriber = subscriber;
            this.flowableMapper = flowableMapper;
            this.singleMapper = singleMapper;
        }

        public void onSubscribe(@NotNull Subscription subscription) {
            this.subscription = subscription;
            this.subscriber.onSubscribe((Subscription)this);
        }

        @Override
        public void onSingle(@NotNull S s) {
            Object sm;
            try {
                sm = Checks.notNull(this.singleMapper.apply(s), "Mapped single value");
            }
            catch (Throwable throwable) {
                this.fail(throwable);
                return;
            }
            this.onSingleMapped(sm);
        }

        void onSingleMapped(@NotNull SM sm) {
        }

        public void onNext(@NotNull F f) {
            if (this.flowableMapper == null) {
                this.subscriber.onNext(f);
            } else {
                Object fm;
                try {
                    fm = Checks.notNull(this.flowableMapper.apply(f), "Mapped value");
                }
                catch (Throwable throwable) {
                    this.fail(throwable);
                    return;
                }
                this.subscriber.onNext(fm);
            }
        }

        void fail(@NotNull Throwable throwable) {
            assert (this.subscription != null);
            Exceptions.throwIfFatal((Throwable)throwable);
            this.subscription.cancel();
            this.onError(throwable);
        }

        public void onError(@NotNull Throwable error) {
            this.subscriber.onError(error);
        }

        public void onComplete() {
            this.subscriber.onComplete();
        }

        public void request(long n) {
            assert (this.subscription != null);
            this.subscription.request(n);
        }

        public void cancel() {
            assert (this.subscription != null);
            this.subscription.cancel();
        }

        private static class Conditional<F, S, FM, SM, T extends ConditionalSubscriber<? super FM>>
        extends MapSubscriber<F, S, FM, SM, T>
        implements WithSingleConditionalSubscriber<F, S> {
            Conditional(@NotNull T subscriber, @Nullable Function<? super F, ? extends FM> flowableMapper, @NotNull Function<? super S, ? extends SM> singleMapper) {
                super(subscriber, flowableMapper, singleMapper);
            }

            public boolean tryOnNext(@NotNull F f) {
                Object fm;
                if (this.flowableMapper == null) {
                    return ((ConditionalSubscriber)this.subscriber).tryOnNext(f);
                }
                try {
                    fm = Checks.notNull(this.flowableMapper.apply(f), "Mapped value");
                }
                catch (Throwable throwable) {
                    this.fail(throwable);
                    return false;
                }
                return ((ConditionalSubscriber)this.subscriber).tryOnNext(fm);
            }
        }
    }
}

