/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.util;

import java.nio.ByteBuffer;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ByteBufferUtil {
    @NotNull
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    @NotNull
    public static ByteBuffer allocate(int capacity, boolean direct) {
        return direct ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity);
    }

    @Nullable
    public static ByteBuffer wrap(@Nullable byte[] binary) {
        return binary == null ? null : ByteBuffer.wrap(binary);
    }

    @Nullable
    public static ByteBuffer slice(@Nullable ByteBuffer byteBuffer) {
        return byteBuffer == null ? null : byteBuffer.slice();
    }

    @NotNull
    public static Optional<ByteBuffer> optionalReadOnly(@Nullable ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return Optional.empty();
        }
        return Optional.of(byteBuffer.asReadOnlyBuffer());
    }

    @NotNull
    public static byte[] getBytes(@NotNull ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            byte[] array = byteBuffer.array();
            if (byteBuffer.arrayOffset() == 0 && array.length == byteBuffer.remaining()) {
                return array;
            }
        }
        return ByteBufferUtil.copyBytes(byteBuffer);
    }

    @NotNull
    public static byte[] copyBytes(@Nullable ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] binary = new byte[byteBuffer.remaining()];
        byteBuffer.duplicate().get(binary);
        return binary;
    }

    private ByteBufferUtil() {
    }
}

