/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.util.collections;

import com.hivemq.client.internal.annotations.NotThreadSafe;
import com.hivemq.client.internal.util.collections.HandleListNode;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NotThreadSafe
public class HandleList<E>
extends HandleListNode<E>
implements Iterable<E> {
    @NotNull
    private final HandleListIterator iterator = new HandleListIterator();

    @NotNull
    public Handle<E> add(@NotNull E element) {
        this.next = new Handle<E>(element, this, this.next);
        return this.next;
    }

    public boolean isEmpty() {
        return this.next == null;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        this.iterator.clear();
        return this.iterator;
    }

    private class HandleListIterator
    implements Iterator<E> {
        @Nullable
        private Handle<E> current;
        @Nullable
        private Handle<E> next;

        private HandleListIterator() {
        }

        private void clear() {
            this.current = null;
            this.next = HandleList.this.next;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        @NotNull
        public E next() {
            Handle current = this.next;
            this.current = current;
            if (current == null) {
                throw new NoSuchElementException();
            }
            this.next = current.next;
            return current.element;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            this.current.remove();
            this.current = null;
        }
    }

    public static class Handle<E>
    extends HandleListNode<E> {
        @NotNull
        final E element;
        @NotNull
        HandleListNode prev;

        Handle(@NotNull E element, @NotNull HandleListNode prev, @Nullable Handle<E> next) {
            this.element = element;
            this.prev = prev;
            this.next = next;
            if (next != null) {
                next.prev = this;
            }
        }

        @NotNull
        public E getElement() {
            return this.element;
        }

        public void remove() {
            Handle next;
            this.prev.next = next = this.next;
            if (next != null) {
                next.prev = this.prev;
            }
        }
    }
}

