/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.otf;

import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.font.otf.GposValueRecord;
import com.itextpdf.io.font.otf.OpenTableLookup;
import com.itextpdf.io.font.otf.OpenTypeFontTableReader;
import com.itextpdf.io.font.otf.OtfReadCommon;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GposLookupType1
extends OpenTableLookup {
    private static final long serialVersionUID = 4562279115440679363L;
    private Map<Integer, GposValueRecord> valueRecordMap = new HashMap<Integer, GposValueRecord>();

    public GposLookupType1(OpenTypeFontTableReader openReader, int lookupFlag, int[] subTableLocations) throws IOException {
        super(openReader, lookupFlag, subTableLocations);
        this.readSubTables();
    }

    @Override
    public boolean transformOne(GlyphLine line) {
        if (line.idx >= line.end) {
            return false;
        }
        if (this.openReader.isSkip(line.get(line.idx).getCode(), this.lookupFlag)) {
            ++line.idx;
            return false;
        }
        int glyphCode = line.get(line.idx).getCode();
        boolean positionApplied = false;
        GposValueRecord valueRecord = this.valueRecordMap.get(glyphCode);
        if (valueRecord != null) {
            Glyph newGlyph = new Glyph(line.get(line.idx));
            newGlyph.setXAdvance((short)(newGlyph.getXAdvance() + valueRecord.XAdvance));
            newGlyph.setYAdvance((short)(newGlyph.getYAdvance() + valueRecord.YAdvance));
            line.set(line.idx, newGlyph);
            positionApplied = true;
        }
        ++line.idx;
        return positionApplied;
    }

    @Override
    protected void readSubTable(int subTableLocation) throws IOException {
        this.openReader.rf.seek(subTableLocation);
        short subTableFormat = this.openReader.rf.readShort();
        int coverageOffset = this.openReader.rf.readUnsignedShort();
        int valueFormat = this.openReader.rf.readUnsignedShort();
        if (subTableFormat == 1) {
            GposValueRecord valueRecord = OtfReadCommon.readGposValueRecord(this.openReader, valueFormat);
            List<Integer> coverageGlyphIds = this.openReader.readCoverageFormat(subTableLocation + coverageOffset);
            for (Integer glyphId : coverageGlyphIds) {
                this.valueRecordMap.put((int)glyphId, valueRecord);
            }
        } else if (subTableFormat == 2) {
            int valueCount = this.openReader.rf.readUnsignedShort();
            ArrayList<GposValueRecord> valueRecords = new ArrayList<GposValueRecord>();
            for (int i = 0; i < valueCount; ++i) {
                GposValueRecord valueRecord = OtfReadCommon.readGposValueRecord(this.openReader, valueFormat);
                valueRecords.add(valueRecord);
            }
            List<Integer> coverageGlyphIds = this.openReader.readCoverageFormat(subTableLocation + coverageOffset);
            for (int i = 0; i < coverageGlyphIds.size(); ++i) {
                this.valueRecordMap.put((int)coverageGlyphIds.get(i), (GposValueRecord)valueRecords.get(i));
            }
        } else {
            throw new IllegalArgumentException("Bad subtable format identifier: " + subTableFormat);
        }
    }
}

