/*
 * Decompiled with CFR 0.152.
 */
package com.lab_440.tentacles.common;

import com.lab_440.tentacles.common.Configuration;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;

public abstract class AbstractRunner {
    protected Configuration conf;
    protected Vertx vertx = Vertx.vertx();
    private Logger logger;

    public AbstractRunner() {
        System.setProperty("vertx.logger-delegate-factory-class-name", "io.vertx.core.logging.SLF4JLogDelegateFactory");
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public abstract void stop();

    public abstract void runWithConf(Configuration var1);

    public void runWithConf(String[] args) {
        this.runWithConf(args.length > 0 ? new Configuration(args[0]) : new Configuration());
    }

    protected void undeployVerticle(String verticleID, String succMsg, String errMsg) {
        this.vertx.undeploy(verticleID, res -> {
            if (!res.succeeded()) {
                this.logger.error((Object)errMsg);
                throw new RuntimeException(errMsg);
            }
            this.logger.info((Object)succMsg);
        });
    }
}

