/*
 * Decompiled with CFR 0.152.
 */
package com.lab_440.tentacles.master;

import com.lab_440.tentacles.common.AbstractRunner;
import com.lab_440.tentacles.common.Configuration;
import com.lab_440.tentacles.master.MasterVerticle;
import com.lab_440.tentacles.master.datastore.DatastoreHelper;
import com.lab_440.tentacles.master.scheduler.SchedulerHelper;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;

public class MasterRunner
extends AbstractRunner {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String masterVerticleID;

    @Override
    public void stop() {
        this.logger.info((Object)"stoping a master runner");
        if (this.vertx == null) {
            return;
        }
        if (this.masterVerticleID != null) {
            this.undeployVerticle(this.masterVerticleID, "Successfully undeployed a master verticle", "Failed to undeploy a master verticle");
        }
    }

    @Override
    public void runWithConf(Configuration conf) {
        this.conf = conf;
        if (conf.getRole() != Configuration.Role.MASTER) {
            this.logger.error((Object)"Run master with wrong config {}", new Object[]{conf.toJsonObject().encode()});
            System.exit(255);
        }
        this.run();
    }

    private void run() {
        this.logger.info((Object)("Role: " + (Object)((Object)this.conf.getRole())));
        DeploymentOptions options = new DeploymentOptions().setConfig(this.conf.toJsonObject());
        try {
            SchedulerHelper.createInstance(this.conf);
            DatastoreHelper.createInstance(this.conf);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage());
            System.exit(255);
        }
        this.deployMasterVerticles(this.conf, options);
    }

    private void deployMasterVerticles(Configuration conf, DeploymentOptions options) {
        this.vertx.deployVerticle(MasterVerticle.class.getName(), options.setInstances(conf.getMasterNum()), res -> {
            if (res.succeeded()) {
                this.masterVerticleID = (String)res.result();
                this.logger.info((Object)"Successfully deployed a master verticle");
            } else {
                this.logger.error((Object)"Failed to run a master verticle: {}", res.cause());
                System.exit(255);
            }
        });
    }
}

