/*
 * Decompiled with CFR 0.152.
 */
package com.lab_440.tentacles.master;

import com.lab_440.tentacles.common.Configuration;
import com.lab_440.tentacles.master.MasterStatus;
import com.lab_440.tentacles.master.datastore.DatastoreHelper;
import com.lab_440.tentacles.master.handlers.FetchUrlsHandler;
import com.lab_440.tentacles.master.handlers.FollowLinksHandler;
import com.lab_440.tentacles.master.handlers.ReplyHandler;
import com.lab_440.tentacles.master.handlers.StoreItemsHandler;
import com.lab_440.tentacles.master.scheduler.SchedulerHelper;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.BodyHandler;

public class MasterVerticle
extends AbstractVerticle {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public void start(Future<Void> startFuture) {
        Configuration conf = new Configuration().fromJsonObject(this.vertx.getOrCreateContext().config());
        HttpServer server = this.vertx.createHttpServer();
        Router router = Router.router((Vertx)this.vertx);
        router.route("/check_master_status").handler(ctx -> ctx.response().end(MasterStatus.RUNNING.toString()));
        router.route("/fetch_urls").handler((Handler)BodyHandler.create());
        router.post("/fetch_urls").handler((Handler)new FetchUrlsHandler(SchedulerHelper.getInstance()));
        router.route("/store_items").handler((Handler)BodyHandler.create());
        router.post("/store_items").handler((Handler)new StoreItemsHandler(DatastoreHelper.getInstance()));
        router.route("/follow_links").handler((Handler)BodyHandler.create());
        router.post("/follow_links").handler((Handler)new FollowLinksHandler(SchedulerHelper.getInstance()));
        router.route("/reply").handler((Handler)BodyHandler.create());
        router.post("/reply").handler((Handler)new ReplyHandler(SchedulerHelper.getInstance()));
        int port = conf.getMasterPort();
        server.requestHandler(arg_0 -> ((Router)router).accept(arg_0)).listen(port);
        startFuture.complete();
        this.logger.info((Object)"Master Verticle started!");
    }
}

