/*
 * Decompiled with CFR 0.152.
 */
package com.lab_440.tentacles.master.handlers;

import com.lab_440.tentacles.common.item.AbstractItem;
import com.lab_440.tentacles.master.scheduler.IScheduler;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;

public class FetchUrlsHandler
implements Handler<RoutingContext> {
    private IScheduler<AbstractItem> scheduler;

    public FetchUrlsHandler(IScheduler<AbstractItem> scheduler) {
        this.scheduler = scheduler;
    }

    public void handle(RoutingContext ctx) {
        ArrayList<AbstractItem> itemList = new ArrayList<AbstractItem>();
        if (this.scheduler != null) {
            HashSet<String> exclude = new HashSet<String>();
            JsonObject jObj = ctx.getBodyAsJson();
            for (Map.Entry entry : jObj) {
                String domain = (String)entry.getKey();
                if (domain.equals("default.domain")) continue;
                exclude.add(domain);
                int batchSize = (Integer)entry.getValue();
                itemList.addAll(this.scheduler.pollBatch(domain, batchSize));
            }
            int batchSize = jObj.getInteger("default.domain");
            itemList.addAll(this.scheduler.pollBatch(exclude, batchSize));
        }
        JsonArray jArr = new JsonArray();
        for (AbstractItem item : itemList) {
            jArr.add(item.toJsonObject());
        }
        ctx.response().end(jArr.encode());
    }
}

