/*
 * Decompiled with CFR 0.152.
 */
package com.lab_440.tentacles.master.handlers;

import com.lab_440.tentacles.common.ProcessStatus;
import com.lab_440.tentacles.common.item.AbstractItem;
import com.lab_440.tentacles.master.scheduler.IScheduler;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.RoutingContext;

public class ReplyHandler
implements Handler<RoutingContext> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private IScheduler<AbstractItem> scheduler;

    public ReplyHandler(IScheduler<AbstractItem> scheduler) {
        this.scheduler = scheduler;
    }

    public void handle(RoutingContext ctx) {
        String resp = "OK";
        if (this.scheduler != null) {
            JsonObject jObj = ctx.getBodyAsJson();
            String status = jObj.getString("status", ProcessStatus.NOT_RETURN.toString());
            String url = jObj.getString("url", "");
            if (status.equals(ProcessStatus.NOT_RETURN.toString())) {
                resp = "Failed to fetch " + url;
                this.logger.error((Object)resp);
            } else if (status.equals(ProcessStatus.BLOCKED.toString())) {
                resp = "Request to " + url + " is BLOCKED";
                this.logger.error((Object)resp);
            } else if (status.equals(ProcessStatus.TMPL_CHANGED.toString())) {
                resp = "Template of " + url + " is CHANGED";
                this.logger.error((Object)resp);
            }
        }
        ctx.response().end(resp);
    }
}

