/*
 * Decompiled with CFR 0.152.
 */
package com.lab_440.tentacles.slave.downloader;

import com.lab_440.tentacles.slave.downloader.IDownloader;
import com.lab_440.tentacles.slave.downloader.ProcessMethod;
import com.lab_440.tentacles.slave.downloader.Processor;
import com.lab_440.tentacles.slave.downloader.Request;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;

public class BaseDownloader
implements IDownloader {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<Method> processMethods;
    private HttpClient httpClient;
    private HttpClient httpsClient;

    public BaseDownloader(Vertx vertx) {
        this.httpClient = vertx.createHttpClient();
        this.httpsClient = vertx.createHttpClient(new HttpClientOptions().setSsl(true));
    }

    @Override
    public void init() {
        PriorityQueue<ProcessMethod> priQueue = new PriorityQueue<ProcessMethod>(64, (a, b) -> a.getPriority() - b.getPriority());
        Method[] methods = this.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Processor annotation = methods[i].getAnnotation(Processor.class);
            if (annotation == null) continue;
            ProcessMethod processMethod = new ProcessMethod(methods[i], annotation.priority());
            priQueue.add(processMethod);
        }
        this.processMethods = new ArrayList<Method>(priQueue.size());
        while (priQueue.size() > 0) {
            ProcessMethod processMethod = (ProcessMethod)priQueue.poll();
            this.processMethods.add(processMethod.getMethod());
        }
    }

    @Override
    public void get(String url, Handler<HttpClientResponse> handler) throws Exception {
        if (url.startsWith("https://")) {
            this.request(this.httpsClient, HttpMethod.GET, url, handler);
        } else {
            this.request(this.httpClient, HttpMethod.GET, url, handler);
        }
    }

    @Override
    public void post(String url, Handler<HttpClientResponse> handler) throws Exception {
        if (url.startsWith("https://")) {
            this.request(this.httpsClient, HttpMethod.POST, url, handler);
        } else {
            this.request(this.httpClient, HttpMethod.POST, url, handler);
        }
    }

    private void request(HttpClient httpClient, HttpMethod httpMethod, String url, Handler<HttpClientResponse> handler) throws Exception {
        HttpClientRequest request = httpClient.requestAbs(httpMethod, url, handler);
        request.setTimeout(3000L);
        Request reqWrapper = new Request(request);
        for (Method method : this.processMethods) {
            method.invoke((Object)this, reqWrapper);
        }
        reqWrapper.onError((Handler<Throwable>)((Handler)err -> this.logger.error((Object)err.getMessage())));
        reqWrapper.end();
    }

    @Processor(priority=100)
    public void setUserAgent(Request request) {
        request.setUserAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64)AppleWebKit/537.36 (KHTML, like Gecko)Chrome/53.0.2785.116Safari/537.36");
    }
}

