/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.xmltool;

import com.mycila.xmltool.Utils;
import com.mycila.xmltool.XMLDocPath;
import com.mycila.xmltool.XMLDocumentException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class XMLDocDefinition
implements NamespaceContext {
    private Element root;
    private final Document document;
    private final XMLDocPath xpath;
    private final Map<String, String> namespaces = new HashMap<String, String>();
    private final boolean ignoreNamespaces;

    XMLDocDefinition(Node node, boolean ignoreNamespaces) {
        this.ignoreNamespaces = ignoreNamespaces;
        this.document = node instanceof Document ? (Document)node : node.getOwnerDocument();
        this.root = this.document.getDocumentElement();
        this.xpath = new XMLDocPath(this);
        this.resetNamespaces();
        this.readNamespaces();
    }

    XMLDocDefinition addNamespace(String prefix, String namespaceURI) throws XMLDocumentException {
        if (!this.ignoreNamespaces) {
            Utils.notNull("prefix", prefix);
            Utils.notNull("namespaceURI", namespaceURI);
            String existing = this.namespaces.get(prefix);
            if (existing != null && !existing.equals(namespaceURI)) {
                throw new XMLDocumentException("Prefix '%s' is already bound to another namespace '%s'", prefix, this.namespaces.get(prefix));
            }
            if (!this.namespaces.values().contains(namespaceURI)) {
                this.namespaces.put(prefix, namespaceURI);
            }
        }
        return this;
    }

    XMLDocDefinition addDefaultNamespace(String defaultNamespaceURI) {
        if (!this.ignoreNamespaces) {
            Utils.notNull("defaultNamespaceURI", defaultNamespaceURI);
            Iterator<String> i = this.getPrefixes(defaultNamespaceURI);
            while (i.hasNext()) {
                this.namespaces.remove(i.next());
            }
            this.namespaces.put("", defaultNamespaceURI);
            this.namespaces.put(this.generatePrefix(), defaultNamespaceURI);
        }
        return this;
    }

    String getEncoding() {
        String enc = this.document.getXmlEncoding();
        return enc == null ? "UTF-8" : enc;
    }

    Document getDocument() {
        return this.document;
    }

    Element getRoot() {
        return this.root;
    }

    XMLDocPath getXpath() {
        return this.xpath;
    }

    Element createElement(String tagName) {
        Utils.notEmpty("tag name", tagName);
        if (this.ignoreNamespaces && tagName.contains(":")) {
            tagName = tagName.substring(tagName.indexOf(":") + 1);
        }
        return this.document.createElementNS(this.getNamespace(tagName), tagName);
    }

    Attr createAttribute(Element current, String name, String value) {
        Utils.notEmpty("Attribute name", name);
        if (this.ignoreNamespaces && name.contains(":")) {
            name = name.substring(name.indexOf(":") + 1);
        }
        Attr attr = this.document.createAttributeNS(this.getNamespace(name), name);
        attr.setValue(value);
        current.setAttributeNodeNS(attr);
        return attr;
    }

    Text createText(String text) {
        Utils.notNull("Text", text);
        return this.document.createTextNode(text);
    }

    CDATASection createCDATA(String data) {
        Utils.notNull("Data", data);
        return this.document.createCDATASection(data);
    }

    XMLDocDefinition createRoot(String tagName) {
        this.root = this.createElement(tagName);
        this.document.appendChild(this.root);
        return this;
    }

    Element rename(Element node, String newNodeName) {
        return this.rename(node, newNodeName, this.getNamespace(newNodeName));
    }

    Element renameWithoutNS(Element node, String newNodeName) {
        return this.rename(node, newNodeName, null);
    }

    Element rename(Element node, String newNodeName, String ns) {
        Element el = (Element)this.getDocument().renameNode(node, ns, newNodeName);
        if (this.root.equals(node)) {
            this.root = el;
        }
        return el;
    }

    public Attr rename(Attr attr, String newTagName) {
        return (Attr)this.getDocument().renameNode(attr, this.getNamespace(newTagName), newTagName);
    }

    public Attr renameWithoutNS(Attr attr, String newTagName) {
        return (Attr)this.getDocument().renameNode(attr, null, newTagName);
    }

    XMLDocDefinition normalize() {
        this.document.normalizeDocument();
        return this;
    }

    void resetNamespaces() {
        this.namespaces.clear();
        this.namespaces.put("xml", "http://www.w3.org/XML/1998/namespace");
        this.namespaces.put("xmlns", "http://www.w3.org/2000/xmlns/");
        this.namespaces.put("", "");
    }

    private String getNamespace(String tagName) {
        int pos = tagName.indexOf(":");
        return this.getNamespaceURI(pos == -1 ? "" : tagName.substring(0, pos));
    }

    void readNamespaces() {
        if (!this.ignoreNamespaces) {
            LinkedHashSet<String> defNs = new LinkedHashSet<String>();
            for (Node node : this.xpath.findNodes(this.root, "//*", new Object[0])) {
                NamedNodeMap attrs = node.getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node attr = attrs.item(i);
                    if ("xmlns".equals(attr.getNodeName())) {
                        defNs.add(attr.getNodeValue());
                        continue;
                    }
                    if (!"xmlns".equals(attr.getPrefix())) continue;
                    this.addNamespace(attr.getNodeName().substring(6), attr.getNodeValue());
                }
            }
            for (String ns : defNs) {
                if (this.defaultNamespaceDefined()) {
                    this.addNamespace(this.generatePrefix(), ns);
                    continue;
                }
                this.addDefaultNamespace(ns);
            }
        }
    }

    private boolean defaultNamespaceDefined() {
        return !"".equals(this.getDefaultNamespace());
    }

    private String getDefaultNamespace() {
        return this.namespaces.get("");
    }

    private String generatePrefix() {
        String prefix = "ns0";
        int i = 1;
        while (this.namespaces.keySet().contains(prefix)) {
            prefix = "ns" + i++;
        }
        return prefix;
    }

    public boolean isIgnoreNamespaces() {
        return this.ignoreNamespaces;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix cannot be null");
        }
        String namespaceURI = this.namespaces.get(prefix);
        return namespaceURI == null ? "" : namespaceURI;
    }

    @Override
    public String getPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("namespaceURI cannot be null");
        }
        for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
            if ("".equals(entry.getKey()) || !entry.getValue().equals(namespaceURI)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("namespaceURI cannot be null");
        }
        HashSet<String> prefixes = new HashSet<String>();
        for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
            if (!entry.getValue().equals(namespaceURI)) continue;
            prefixes.add(entry.getKey());
        }
        return prefixes.iterator();
    }
}

