/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator;

import com.google.common.base.Preconditions;
import com.netflix.curator.ConnectionState;
import com.netflix.curator.RetryLoop;
import com.netflix.curator.RetryPolicy;
import com.netflix.curator.TimeTrace;
import com.netflix.curator.drivers.TracerDriver;
import com.netflix.curator.utils.DefaultTracerDriver;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuratorZookeeperClient
implements Closeable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ConnectionState state;
    private final AtomicReference<RetryPolicy> retryPolicy = new AtomicReference();
    private final int connectionTimeoutMs;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicReference<TracerDriver> tracer = new AtomicReference<DefaultTracerDriver>(new DefaultTracerDriver());

    public CuratorZookeeperClient(String connectString, int sessionTimeoutMs, int connectionTimeoutMs, Watcher watcher, RetryPolicy retryPolicy) throws IOException {
        Preconditions.checkNotNull((Object)connectString);
        Preconditions.checkNotNull((Object)retryPolicy);
        this.connectionTimeoutMs = connectionTimeoutMs;
        this.state = new ConnectionState(connectString, sessionTimeoutMs, connectionTimeoutMs, watcher, this.tracer);
        this.setRetryPolicy(retryPolicy);
    }

    public ZooKeeper getZooKeeper() throws Exception {
        return this.state.getZooKeeper();
    }

    public RetryLoop newRetryLoop() {
        return new RetryLoop(this.retryPolicy.get(), this.tracer);
    }

    public boolean isConnected() {
        return this.state.isConnected();
    }

    public boolean blockUntilConnectedOrTimedOut() throws InterruptedException {
        Preconditions.checkArgument((boolean)this.started.get());
        this.log.debug("blockUntilConnectedOrTimedOut() start");
        TimeTrace trace = this.startTracer("blockUntilConnectedOrTimedOut");
        this.internalBlockUntilConnectedOrTimedOut();
        trace.commit();
        boolean localIsConnected = this.state.isConnected();
        this.log.debug("blockUntilConnectedOrTimedOut() end. isConnected: " + localIsConnected);
        return localIsConnected;
    }

    public void start() throws Exception {
        this.log.debug("Starting");
        if (!this.started.compareAndSet(false, true)) {
            IllegalStateException error = new IllegalStateException();
            this.log.error("Already started", (Throwable)error);
            throw error;
        }
        this.state.start();
    }

    @Override
    public void close() {
        this.log.debug("Closing");
        this.started.set(false);
        try {
            this.state.close();
        }
        catch (IOException e) {
            this.log.error("", (Throwable)e);
        }
    }

    public void setRetryPolicy(RetryPolicy policy) {
        Preconditions.checkNotNull((Object)policy);
        this.retryPolicy.set(policy);
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy.get();
    }

    public TimeTrace startTracer(String name) {
        return new TimeTrace(name, this.tracer.get());
    }

    public TracerDriver getTracerDriver() {
        return this.tracer.get();
    }

    public void setTracerDriver(TracerDriver tracer) {
        this.tracer.set(tracer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalBlockUntilConnectedOrTimedOut() throws InterruptedException {
        long elapsed;
        for (long waitTimeMs = (long)this.connectionTimeoutMs; !this.state.isConnected() && waitTimeMs > 0L; waitTimeMs -= elapsed) {
            final AtomicReference<Object> previousWatcher = new AtomicReference<Object>(null);
            final CountDownLatch latch = new CountDownLatch(1);
            Watcher tempWatcher = new Watcher(){

                public void process(WatchedEvent event) {
                    Watcher localPreviousWatcher = (Watcher)previousWatcher.get();
                    if (localPreviousWatcher != null) {
                        localPreviousWatcher.process(event);
                    }
                    latch.countDown();
                }
            };
            previousWatcher.set(this.state.substituteParentWatcher(tempWatcher));
            long startTimeMs = System.currentTimeMillis();
            try {
                latch.await(1L, TimeUnit.SECONDS);
            }
            finally {
                this.state.substituteParentWatcher(previousWatcher.get());
            }
            elapsed = Math.max(1L, System.currentTimeMillis() - startTimeMs);
        }
    }
}

