/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator;

import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

class HandleHolder {
    private final Watcher watcher;
    private final String connectString;
    private final int sessionTimeout;
    private volatile Helper helper;

    HandleHolder(Watcher watcher, String connectString, int sessionTimeout) {
        this.watcher = watcher;
        this.connectString = connectString;
        this.sessionTimeout = sessionTimeout;
    }

    ZooKeeper getZooKeeper() throws Exception {
        return this.helper.getZooKeeper();
    }

    void closeAndClear() throws Exception {
        this.internalClose();
        this.helper = null;
    }

    void closeAndReset() throws Exception {
        this.internalClose();
        this.helper = new Helper(){
            private volatile ZooKeeper zooKeeperHandle = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ZooKeeper getZooKeeper() throws Exception {
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (this.zooKeeperHandle == null) {
                        this.zooKeeperHandle = new ZooKeeper(HandleHolder.this.connectString, HandleHolder.this.sessionTimeout, HandleHolder.this.watcher);
                    }
                    HandleHolder.this.helper = new Helper(){

                        @Override
                        public ZooKeeper getZooKeeper() throws Exception {
                            return zooKeeperHandle;
                        }
                    };
                    return this.zooKeeperHandle;
                }
            }
        };
    }

    private void internalClose() throws Exception {
        try {
            ZooKeeper zooKeeper;
            ZooKeeper zooKeeper2 = zooKeeper = this.helper != null ? this.helper.getZooKeeper() : null;
            if (zooKeeper != null) {
                zooKeeper.close();
            }
        }
        catch (InterruptedException dummy) {
            Thread.currentThread().interrupt();
        }
    }

    private static interface Helper {
        public ZooKeeper getZooKeeper() throws Exception;
    }
}

