/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Statistic;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.atlas.AtlasMeter;
import com.netflix.spectator.atlas.DsType;
import com.netflix.spectator.impl.StepDouble;
import java.util.Collections;

class AtlasMaxGauge
extends AtlasMeter
implements Gauge {
    private final StepDouble value;
    private final Id stat;

    AtlasMaxGauge(Id id, Clock clock, long ttl, long step) {
        super(id, clock, ttl);
        this.value = new StepDouble(0.0, clock, step);
        this.stat = id.withTag((Tag)Statistic.max).withTags(id.tags()).withTag((Tag)DsType.gauge);
    }

    public Iterable<Measurement> measure() {
        double v = this.value.poll();
        Measurement m = new Measurement(this.stat, this.value.timestamp(), v);
        return Collections.singletonList(m);
    }

    public void set(double v) {
        this.value.getCurrent().max(v);
        this.updateLastModTime();
    }

    public double value() {
        return this.value.poll();
    }
}

