/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas.impl;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Statistic;
import com.netflix.spectator.api.Utils;
import com.netflix.spectator.impl.Preconditions;

public interface Consolidator {
    public void update(long var1, double var3);

    default public void update(Measurement m) {
        this.update(m.timestamp(), m.value());
    }

    public double value(long var1);

    public boolean isEmpty();

    public static Consolidator create(Id id, long step, int multiple) {
        return Consolidator.create(Utils.getTagValue((Id)id, (String)"statistic"), step, multiple);
    }

    public static Consolidator create(Statistic statistic, long step, int multiple) {
        return Consolidator.create(statistic.name(), step, multiple);
    }

    public static Consolidator create(String statistic, long step, int multiple) {
        AbstractConsolidator consolidator;
        if (multiple == 1) {
            return new None();
        }
        switch (statistic == null ? "gauge" : statistic) {
            case "count": 
            case "totalAmount": 
            case "totalTime": 
            case "totalOfSquares": 
            case "percentile": {
                consolidator = new Avg(step, multiple);
                break;
            }
            default: {
                consolidator = new Max(step, multiple);
            }
        }
        return consolidator;
    }

    public static final class Max
    extends AbstractConsolidator {
        Max(long step, int multiple) {
            super(step, multiple);
        }

        @Override
        protected double aggregate(double v1, double v2) {
            return Double.isNaN(v1) ? v2 : (Double.isNaN(v2) ? v1 : Math.max(v1, v2));
        }

        @Override
        protected double complete(double v) {
            return v;
        }
    }

    public static final class Avg
    extends AbstractConsolidator {
        Avg(long step, int multiple) {
            super(step, multiple);
        }

        @Override
        protected double aggregate(double v1, double v2) {
            return Double.isNaN(v1) ? v2 : (Double.isNaN(v2) ? v1 : v1 + v2);
        }

        @Override
        protected double complete(double v) {
            return v / (double)this.multiple;
        }
    }

    public static abstract class AbstractConsolidator
    implements Consolidator {
        protected final long step;
        protected final int multiple;
        private long timestamp;
        private double current;
        private double previous;

        AbstractConsolidator(long step, int multiple) {
            Preconditions.checkArg((step > 0L ? 1 : 0) != 0, (String)"step must be > 0");
            Preconditions.checkArg(((long)multiple > 0L ? 1 : 0) != 0, (String)"multiple must be > 0");
            this.step = step;
            this.multiple = multiple;
            this.timestamp = -1L;
            this.current = Double.NaN;
            this.previous = Double.NaN;
        }

        private long roundToConsolidatedStep(long t) {
            return t % this.step == 0L ? t : t / this.step * this.step + this.step;
        }

        protected abstract double aggregate(double var1, double var3);

        protected abstract double complete(double var1);

        @Override
        public void update(long rawTimestamp, double value) {
            long t = this.roundToConsolidatedStep(rawTimestamp);
            if (this.timestamp < 0L) {
                this.timestamp = t;
            }
            if (t == this.timestamp) {
                this.current = this.aggregate(this.current, value);
                if (rawTimestamp == this.timestamp) {
                    this.previous = this.complete(this.current);
                    this.current = Double.NaN;
                    this.timestamp = t + this.step;
                }
            } else if (t > this.timestamp) {
                this.previous = t - this.timestamp == this.step ? this.complete(this.current) : Double.NaN;
                this.current = value;
                this.timestamp = t;
            }
        }

        @Override
        public double value(long t) {
            return this.timestamp - t == this.step ? this.previous : Double.NaN;
        }

        @Override
        public boolean isEmpty() {
            return Double.isNaN(this.previous) && Double.isNaN(this.current);
        }
    }

    public static final class None
    implements Consolidator {
        private long timestamp = -1L;
        private double value = Double.NaN;

        None() {
        }

        @Override
        public void update(long t, double v) {
            if (t > this.timestamp) {
                this.timestamp = t;
                this.value = v;
            }
        }

        @Override
        public double value(long t) {
            return this.timestamp == t ? this.value : Double.NaN;
        }

        @Override
        public boolean isEmpty() {
            return Double.isNaN(this.value);
        }
    }
}

