/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.internal;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public final class CompletionStageUtil {
    public static final CompletableFuture<Void> VOID_COMPLETED_FUTURE = CompletableFuture.completedFuture(null);

    private CompletionStageUtil() {
    }

    public static void acceptCompletion(CompletionHandler completionHandler) {
        try {
            completionHandler.handle();
        }
        catch (Exception exception) {
            throw new CompletionException(exception);
        }
    }

    public static <T> T handleCompletion(T t2, Throwable throwable, CompletionHandler completionHandler) {
        CompletionStageUtil.acceptCompletion(completionHandler);
        if (throwable == null) {
            return t2;
        }
        if (throwable instanceof CompletionException) {
            throw (CompletionException)throwable;
        }
        throw new CompletionException(throwable);
    }

    public static <T> BiFunction<T, Throwable, T> completionHandler(CompletionHandler completionHandler) {
        return (object, throwable) -> CompletionStageUtil.handleCompletion(object, throwable, completionHandler);
    }

    public static <T, U> U handleNormalCompletion(T t2, NormalCompletionHandler<T, U> normalCompletionHandler) {
        try {
            return normalCompletionHandler.handle(t2);
        }
        catch (Exception exception) {
            throw new CompletionException(exception);
        }
    }

    public static <T, U> U handleNormalCompletion(T t2, Throwable throwable, NormalCompletionHandler<T, U> normalCompletionHandler) {
        if (throwable == null) {
            return CompletionStageUtil.handleNormalCompletion(t2, normalCompletionHandler);
        }
        if (throwable instanceof CompletionException) {
            throw (CompletionException)throwable;
        }
        throw new CompletionException(throwable);
    }

    public static <T, U> Function<T, U> normalCompletionHandler(NormalCompletionHandler<T, U> normalCompletionHandler) {
        return object -> CompletionStageUtil.handleNormalCompletion(object, normalCompletionHandler);
    }

    public static <E extends Throwable, T> T handleExceptionalCompletion(Throwable throwable, Class<E> clazz, ExceptionalCompletionHandler<? super E, ? extends T> exceptionalCompletionHandler) {
        if (throwable == null) {
            return null;
        }
        Throwable throwable2 = CompletionStageUtil.unwrapCompletionException(throwable);
        if (clazz.isInstance(throwable2)) {
            try {
                return exceptionalCompletionHandler.handle(throwable2);
            }
            catch (Exception exception) {
                throw new CompletionException(exception);
            }
        }
        throw new CompletionException(throwable2);
    }

    public static <E extends Throwable, T> Function<Throwable, T> exceptionalCompletionHandler(Class<E> clazz, ExceptionalCompletionHandler<? super E, T> exceptionalCompletionHandler) {
        return throwable -> CompletionStageUtil.handleExceptionalCompletion(throwable, clazz, exceptionalCompletionHandler);
    }

    public static <T, E extends Throwable, U> U handleCompletion(T t2, NormalCompletionHandler<? super T, U> normalCompletionHandler, Throwable throwable, Class<E> clazz, ExceptionalCompletionHandler<? super E, ? extends U> exceptionalCompletionHandler) {
        return throwable == null ? CompletionStageUtil.handleNormalCompletion(t2, normalCompletionHandler) : CompletionStageUtil.handleExceptionalCompletion(throwable, clazz, exceptionalCompletionHandler);
    }

    public static <T, E extends Throwable, U> BiFunction<T, Throwable, U> completionHandler(NormalCompletionHandler<T, U> normalCompletionHandler, Class<E> clazz, ExceptionalCompletionHandler<? super E, U> exceptionalCompletionHandler) {
        return (object, throwable) -> CompletionStageUtil.handleCompletion(object, normalCompletionHandler, throwable, clazz, exceptionalCompletionHandler);
    }

    public static Throwable unwrapCompletionException(Throwable throwable) {
        if (throwable instanceof CompletionException) {
            return throwable.getCause();
        }
        return throwable;
    }

    public static <T> CompletionStage<T> completedStage(T t2) {
        return CompletableFuture.completedFuture(t2);
    }

    public static <T> CompletionStage<T> failedStage(Throwable throwable) {
        CompletableFuture completableFuture = new CompletableFuture();
        completableFuture.completeExceptionally(throwable);
        return completableFuture;
    }

    public static void callOnComplete(CompletionStage<Void> completionStage, Consumer<Throwable> consumer) {
        CompletionStageUtil.callOnComplete(completionStage, (T void_, Throwable throwable) -> consumer.accept((Throwable)throwable));
    }

    public static <T> void callOnComplete(CompletionStage<T> completionStage, BiConsumer<T, Throwable> biConsumer) {
        CompletableFuture<T> completableFuture = completionStage.toCompletableFuture();
        if (completableFuture.isDone() && !completableFuture.isCompletedExceptionally()) {
            biConsumer.accept(completableFuture.join(), null);
        } else {
            completableFuture.whenComplete((BiConsumer)biConsumer);
        }
    }

    public static <T extends Throwable> T suppress(T t2, Throwable throwable) {
        if (throwable != null) {
            t2.addSuppressed(throwable);
        }
        return t2;
    }

    @FunctionalInterface
    public static interface ExceptionalCompletionHandler<E extends Throwable, T>
    extends Function<E, T> {
        public T handle(E var1) throws Exception;

        @Override
        default public T apply(E e2) {
            try {
                return this.handle(e2);
            }
            catch (Exception exception) {
                throw new CompletionException(exception);
            }
        }
    }

    @FunctionalInterface
    public static interface NormalCompletionHandler<T, U>
    extends Function<T, U> {
        public U handle(T var1) throws Exception;

        @Override
        default public U apply(T t2) {
            try {
                return this.handle(t2);
            }
            catch (Exception exception) {
                throw new CompletionException(exception);
            }
        }
    }

    @FunctionalInterface
    public static interface CompletionHandler
    extends Runnable {
        public void handle() throws Exception;

        @Override
        default public void run() {
            try {
                this.handle();
            }
            catch (Exception exception) {
                throw new CompletionException(exception);
            }
        }
    }
}

