/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.Filter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class FilterSet
implements Filter {
    private final Set<Filter> filters = new HashSet<Filter>();

    public void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    public void removeFilter(Filter filter) {
        this.filters.remove(filter);
    }

    public Set<Filter> getFilters() {
        return Collections.unmodifiableSet(this.filters);
    }

    public String toString() {
        return this.filters.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FilterSet filterSet = (FilterSet)other;
        return Objects.equals(this.filters, filterSet.filters);
    }

    public int hashCode() {
        return Objects.hash(this.filters);
    }

    @Override
    public boolean accept(AuditEvent event) {
        boolean result = true;
        for (Filter filter : this.filters) {
            if (filter.accept(event)) continue;
            result = false;
            break;
        }
        return result;
    }

    public void clear() {
        this.filters.clear();
    }
}

