/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.blocks;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.checks.blocks.RightCurlyOption;
import com.puppycrawl.tools.checkstyle.utils.CheckUtil;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtil;
import java.util.Locale;

@StatelessCheck
public class RightCurlyCheck
extends AbstractCheck {
    public static final String MSG_KEY_LINE_BREAK_BEFORE = "line.break.before";
    public static final String MSG_KEY_LINE_ALONE = "line.alone";
    public static final String MSG_KEY_LINE_SAME = "line.same";
    public static final String MSG_KEY_LINE_NEW = "line.new";
    private boolean shouldStartLine = true;
    private RightCurlyOption option = RightCurlyOption.SAME;

    public void setOption(String optionStr) {
        this.option = RightCurlyOption.valueOf(optionStr.trim().toUpperCase(Locale.ENGLISH));
    }

    public void setShouldStartLine(boolean flag) {
        this.shouldStartLine = flag;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{95, 96, 97, 83, 92};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{95, 96, 97, 83, 92, 14, 9, 8, 91, 84, 85, 12, 11};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        String violation;
        Details details = Details.getDetails(ast);
        DetailAST rcurly = details.rcurly;
        if (rcurly != null && !(violation = this.validate(details)).isEmpty()) {
            this.log(rcurly, violation, "}", rcurly.getColumnNo() + 1);
        }
    }

    private String validate(Details details) {
        String targetSourceLine;
        String violation = "";
        if (RightCurlyCheck.shouldHaveLineBreakBefore(this.option, details)) {
            violation = MSG_KEY_LINE_BREAK_BEFORE;
        } else if (RightCurlyCheck.shouldBeOnSameLine(this.option, details)) {
            violation = MSG_KEY_LINE_SAME;
        } else if (RightCurlyCheck.shouldBeAloneOnLine(this.option, details)) {
            violation = MSG_KEY_LINE_ALONE;
        } else if (this.shouldStartLine && !RightCurlyCheck.isOnStartOfLine(details, targetSourceLine = this.getLines()[details.rcurly.getLineNo() - 1])) {
            violation = MSG_KEY_LINE_NEW;
        }
        return violation;
    }

    private static boolean shouldHaveLineBreakBefore(RightCurlyOption bracePolicy, Details details) {
        return bracePolicy == RightCurlyOption.SAME && !RightCurlyCheck.hasLineBreakBefore(details.rcurly) && details.lcurly.getLineNo() != details.rcurly.getLineNo();
    }

    private static boolean shouldBeOnSameLine(RightCurlyOption bracePolicy, Details details) {
        return bracePolicy == RightCurlyOption.SAME && !details.shouldCheckLastRcurly && details.rcurly.getLineNo() != details.nextToken.getLineNo();
    }

    private static boolean shouldBeAloneOnLine(RightCurlyOption bracePolicy, Details details) {
        return bracePolicy == RightCurlyOption.ALONE && RightCurlyCheck.shouldBeAloneOnLineWithAloneOption(details) || bracePolicy == RightCurlyOption.ALONE_OR_SINGLELINE && RightCurlyCheck.shouldBeAloneOnLineWithAloneOrSinglelineOption(details) || details.shouldCheckLastRcurly && details.rcurly.getLineNo() == details.nextToken.getLineNo();
    }

    private static boolean shouldBeAloneOnLineWithAloneOption(Details details) {
        return !RightCurlyCheck.isAloneOnLine(details) && !RightCurlyCheck.isEmptyBody(details.lcurly);
    }

    private static boolean shouldBeAloneOnLineWithAloneOrSinglelineOption(Details details) {
        return !RightCurlyCheck.isAloneOnLine(details) && !RightCurlyCheck.isSingleLineBlock(details) && !RightCurlyCheck.isAnonInnerClassInit(details.lcurly) && !RightCurlyCheck.isEmptyBody(details.lcurly);
    }

    private static boolean isOnStartOfLine(Details details, String targetSourceLine) {
        return CommonUtil.hasWhitespaceBefore(details.rcurly.getColumnNo(), targetSourceLine) || details.lcurly.getLineNo() == details.rcurly.getLineNo();
    }

    private static boolean isAloneOnLine(Details details) {
        DetailAST rcurly = details.rcurly;
        DetailAST lcurly = details.lcurly;
        DetailAST nextToken = details.nextToken;
        return rcurly.getLineNo() != lcurly.getLineNo() && rcurly.getLineNo() != nextToken.getLineNo();
    }

    private static boolean isSingleLineBlock(Details details) {
        DetailAST rcurly = details.rcurly;
        DetailAST lcurly = details.lcurly;
        DetailAST nextToken = details.nextToken;
        return rcurly.getLineNo() == lcurly.getLineNo() && rcurly.getLineNo() != nextToken.getLineNo();
    }

    private static boolean isAnonInnerClassInit(DetailAST lcurly) {
        Scope surroundingScope = ScopeUtil.getSurroundingScope(lcurly);
        return surroundingScope.ordinal() == Scope.ANONINNER.ordinal();
    }

    private static boolean isEmptyBody(DetailAST lcurly) {
        boolean result = false;
        if (lcurly.getParent().getType() == 6) {
            if (lcurly.getNextSibling().getType() == 73) {
                result = true;
            }
        } else if (lcurly.getFirstChild().getType() == 73) {
            result = true;
        }
        return result;
    }

    private static boolean hasLineBreakBefore(DetailAST rightCurly) {
        DetailAST previousToken = rightCurly.getPreviousSibling();
        return previousToken == null || rightCurly.getLineNo() != previousToken.getLineNo();
    }

    private static final class Details {
        private final DetailAST rcurly;
        private final DetailAST lcurly;
        private final DetailAST nextToken;
        private final boolean shouldCheckLastRcurly;

        private Details(DetailAST lcurly, DetailAST rcurly, DetailAST nextToken, boolean shouldCheckLastRcurly) {
            this.lcurly = lcurly;
            this.rcurly = rcurly;
            this.nextToken = nextToken;
            this.shouldCheckLastRcurly = shouldCheckLastRcurly;
        }

        private static Details getDetails(DetailAST ast) {
            Details details;
            switch (ast.getType()) {
                case 95: 
                case 96: 
                case 97: {
                    details = Details.getDetailsForTryCatchFinally(ast);
                    break;
                }
                case 83: 
                case 92: {
                    details = Details.getDetailsForIfElse(ast);
                    break;
                }
                case 84: 
                case 85: 
                case 91: {
                    details = Details.getDetailsForLoops(ast);
                    break;
                }
                default: {
                    details = Details.getDetailsForOthers(ast);
                }
            }
            return details;
        }

        private static Details getDetailsForTryCatchFinally(DetailAST ast) {
            DetailAST rcurly;
            DetailAST nextToken;
            DetailAST lcurly;
            boolean shouldCheckLastRcurly = false;
            int tokenType = ast.getType();
            if (tokenType == 95) {
                lcurly = ast.getFirstChild().getType() == 176 ? ast.getFirstChild().getNextSibling() : ast.getFirstChild();
                nextToken = lcurly.getNextSibling();
                rcurly = lcurly.getLastChild();
                if (nextToken == null) {
                    shouldCheckLastRcurly = true;
                    nextToken = Details.getNextToken(ast);
                }
            } else if (tokenType == 96) {
                nextToken = ast.getNextSibling();
                lcurly = ast.getLastChild();
                rcurly = lcurly.getLastChild();
                if (nextToken == null) {
                    shouldCheckLastRcurly = true;
                    nextToken = Details.getNextToken(ast);
                }
            } else {
                shouldCheckLastRcurly = true;
                nextToken = Details.getNextToken(ast);
                lcurly = ast.getFirstChild();
                rcurly = lcurly.getLastChild();
            }
            return new Details(lcurly, rcurly, nextToken, shouldCheckLastRcurly);
        }

        private static Details getDetailsForIfElse(DetailAST ast) {
            DetailAST lcurly;
            DetailAST nextToken;
            boolean shouldCheckLastRcurly = false;
            int tokenType = ast.getType();
            if (tokenType == 83) {
                nextToken = ast.findFirstToken(92);
                if (nextToken == null) {
                    shouldCheckLastRcurly = true;
                    nextToken = Details.getNextToken(ast);
                    lcurly = ast.getLastChild();
                } else {
                    lcurly = nextToken.getPreviousSibling();
                }
            } else {
                shouldCheckLastRcurly = true;
                nextToken = Details.getNextToken(ast);
                lcurly = ast.getFirstChild();
            }
            DetailAST rcurly = null;
            if (lcurly.getType() == 7) {
                rcurly = lcurly.getLastChild();
            }
            return new Details(lcurly, rcurly, nextToken, shouldCheckLastRcurly);
        }

        private static Details getDetailsForOthers(DetailAST ast) {
            DetailAST nextToken;
            DetailAST lcurly;
            DetailAST rcurly = null;
            int tokenType = ast.getType();
            if (tokenType == 14) {
                DetailAST child = ast.getLastChild();
                lcurly = child.getFirstChild();
                rcurly = child.getLastChild();
                nextToken = ast;
            } else {
                lcurly = ast.findFirstToken(7);
                if (lcurly != null) {
                    rcurly = lcurly.getLastChild();
                }
                nextToken = Details.getNextToken(ast);
            }
            return new Details(lcurly, rcurly, nextToken, false);
        }

        private static Details getDetailsForLoops(DetailAST ast) {
            DetailAST lcurly;
            DetailAST nextToken;
            DetailAST rcurly = null;
            int tokenType = ast.getType();
            if (tokenType == 85) {
                nextToken = ast.findFirstToken(175);
                lcurly = ast.findFirstToken(7);
                if (lcurly != null) {
                    rcurly = lcurly.getLastChild();
                }
            } else {
                lcurly = ast.findFirstToken(7);
                if (lcurly != null) {
                    rcurly = lcurly.getLastChild();
                }
                nextToken = Details.getNextToken(ast);
            }
            return new Details(lcurly, rcurly, nextToken, false);
        }

        private static DetailAST getNextToken(DetailAST ast) {
            DetailAST next = null;
            DetailAST parent = ast;
            while (next == null) {
                next = parent.getNextSibling();
                parent = parent.getParent();
            }
            return CheckUtil.getFirstNode(next);
        }
    }
}

