/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cosapi.file;

import com.qcloud.cosapi.sign.CommonCodecUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileProcess {
    private static Logger LOG = LoggerFactory.getLogger(FileProcess.class);

    public static boolean isLegalFile(String filePath) {
        File file = new File(filePath);
        return file.exists() && !file.isDirectory() && file.canRead();
    }

    public static long getFileLength(String filePath) throws Exception {
        if (!FileProcess.isLegalFile(filePath)) {
            String errorMsg = filePath + " is not file or not exist or can't be read!";
            LOG.error(errorMsg);
            throw new Exception(errorMsg);
        }
        File file = new File(filePath);
        return file.length();
    }

    public static FileInputStream getFileInputStream(String filePath) throws Exception {
        if (!FileProcess.isLegalFile(filePath)) {
            String errorMsg = filePath + " is not file or not exist or can't be read!";
            LOG.error(errorMsg);
            throw new Exception(errorMsg);
        }
        FileInputStream localFileInputStream = new FileInputStream(filePath);
        return localFileInputStream;
    }

    public static void closeFileStream(InputStream inputStream, String filePath) throws IOException {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException e) {
            LOG.error("close file {} occur a IOExcpetion {}", (Object)filePath, (Object)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFileContent(String filePath, long offset, int length) throws Exception {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = FileProcess.getFileInputStream(filePath);
            byte[] byArray = FileProcess.getFileContent(fileInputStream, offset, length);
            return byArray;
        }
        finally {
            FileProcess.closeFileStream(fileInputStream, filePath);
        }
    }

    public static byte[] getFileContent(InputStream inputStream) throws Exception {
        return FileProcess.getFileContent(inputStream, 0L, inputStream.available());
    }

    public static byte[] getFileContent(InputStream inputStream, long offset, int length) throws Exception {
        if (offset < 0L || length < 0) {
            throw new Exception("get file content param error");
        }
        byte[] fileContent = null;
        byte[] tempBuf = new byte[length];
        inputStream.skip(offset);
        int readLen = inputStream.read(tempBuf);
        if (readLen < 0) {
            fileContent = new byte[]{};
            return fileContent;
        }
        if (readLen < length) {
            fileContent = new byte[readLen];
            System.arraycopy(tempBuf, 0, fileContent, 0, readLen);
        } else {
            fileContent = tempBuf;
        }
        return fileContent;
    }

    public static String getFileSha1(String filePath) throws Exception {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = FileProcess.getFileInputStream(filePath);
            String string = CommonCodecUtils.getFileSha1(fileInputStream);
            return string;
        }
        catch (Exception e) {
            LOG.error("getFileSha1 occur a exception, file {}, exception {}", (Object)filePath, (Object)e.toString());
            throw e;
        }
        finally {
            FileProcess.closeFileStream(fileInputStream, filePath);
        }
    }
}

