/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cosapi.http;

import com.qcloud.cosapi.http.IdleConnectionMonitorThread;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSender {
    private static final int DEFAULT_MAX_TOTAL_CONNECTION = 500;
    private static final int DEFAULT_MAX_ROUTE_CONNECTION = 500;
    private static final int DEFAULT_MAX_RETRY_COUNT = 3;
    private HttpClient cosHttpClient = this.initHttpClient();
    private IdleConnectionMonitorThread idleMonitor;
    private static final Logger LOG = LoggerFactory.getLogger(HttpSender.class);

    private HttpClient initHttpClient() {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(500);
        connectionManager.setDefaultMaxPerRoute(500);
        this.idleMonitor = new IdleConnectionMonitorThread((HttpClientConnectionManager)connectionManager);
        this.idleMonitor.start();
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
    }

    private String getErrorHttpResponseMsg(String methondName, String url, StatusLine responseStatus) {
        String errMsg = methondName + " to url:" + url + " get error response, protocol:" + responseStatus.getProtocolVersion().toString() + ", code:" + responseStatus.getStatusCode() + ", reason:" + responseStatus.getReasonPhrase();
        return errMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendGetRequest(String url, Map<String, String> headers, Map<String, String> params, int timeout) throws Exception {
        int retry = 0;
        String responseStr = "";
        while (retry < 3) {
            HttpGet httpGet = null;
            try {
                URIBuilder urlBuilder = new URIBuilder(url);
                if (params != null) {
                    for (String paramKey : params.keySet()) {
                        urlBuilder.addParameter(paramKey, params.get(paramKey));
                    }
                }
                httpGet = new HttpGet(urlBuilder.build());
            }
            catch (URISyntaxException e) {
                LOG.error("Invalid url: {}", (Object)url);
                throw e;
            }
            this.setTimeout((HttpRequestBase)httpGet, timeout);
            this.setHeaders((HttpMessage)httpGet, headers);
            try {
                HttpResponse httpResponse = this.cosHttpClient.execute((HttpUriRequest)httpGet);
                int statusCode = httpResponse.getStatusLine().getStatusCode();
                if (statusCode == 200 || statusCode == 400) {
                    String paramKey;
                    paramKey = responseStr = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
                    return paramKey;
                }
                String errMsg = this.getErrorHttpResponseMsg("sendGetRequest", url, httpResponse.getStatusLine());
                LOG.error(errMsg);
                JSONObject errorRet = new JSONObject();
                errorRet.put("code", -2);
                errorRet.put("message", (Object)errMsg);
                String string = errorRet.toString();
                return string;
            }
            catch (IOException | ParseException e) {
                if (++retry != 3) continue;
                LOG.error("Send Get Request occur a error: {}", (Object)e.toString());
                JSONObject errorRet = new JSONObject();
                errorRet.put("code", -2);
                errorRet.put("message", (Object)e.toString());
                responseStr = errorRet.toString();
            }
            finally {
                httpGet.releaseConnection();
            }
        }
        return responseStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendJsonRequest(String url, Map<String, String> headers, Map<String, String> params, int timeout) throws Exception {
        int retry = 0;
        String responseStr = "";
        while (retry < 3) {
            HttpPost httpPost = new HttpPost(url);
            this.setTimeout((HttpRequestBase)httpPost, timeout);
            this.setHeaders((HttpMessage)httpPost, headers);
            ContentType utf8TextPlain = ContentType.create((String)"text/plain", (Charset)Consts.UTF_8);
            String postJsonStr = new JSONObject(params).toString();
            StringEntity stringEntity = new StringEntity(postJsonStr, utf8TextPlain);
            httpPost.setEntity((HttpEntity)stringEntity);
            try {
                HttpResponse httpResponse = this.cosHttpClient.execute((HttpUriRequest)httpPost);
                int statusCode = httpResponse.getStatusLine().getStatusCode();
                if (statusCode == 200 || statusCode == 400) {
                    String string = responseStr = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
                    return string;
                }
                String errMsg = this.getErrorHttpResponseMsg("sendJsonRequest", url, httpResponse.getStatusLine());
                LOG.error(errMsg);
                JSONObject errorRet = new JSONObject();
                errorRet.put("code", -2);
                errorRet.put("message", (Object)errMsg);
                String string = errorRet.toString();
                return string;
            }
            catch (IOException | ParseException e) {
                if (++retry != 3) continue;
                LOG.error("sendJsonRequest occur a error: {}", (Object)e.toString());
                JSONObject errorRet = new JSONObject();
                errorRet.put("code", -2);
                errorRet.put("message", (Object)e.toString());
                responseStr = errorRet.toString();
            }
            finally {
                httpPost.releaseConnection();
            }
        }
        return responseStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendFileRequest(String url, Map<String, String> headers, Map<String, String> params, byte[] fileContent, int timeout) throws Exception {
        int retry = 0;
        String responseStr = "";
        while (retry < 3) {
            HttpPost httpPost = new HttpPost(url);
            this.setTimeout((HttpRequestBase)httpPost, timeout);
            this.setHeaders((HttpMessage)httpPost, headers);
            MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
            if (fileContent != null) {
                entityBuilder.addBinaryBody("fileContent", fileContent);
            }
            ContentType utf8TextPlain = ContentType.create((String)"text/plain", (Charset)Consts.UTF_8);
            if (params != null) {
                for (String paramKey : params.keySet()) {
                    entityBuilder.addTextBody(paramKey, params.get(paramKey), utf8TextPlain);
                }
            }
            httpPost.setEntity(entityBuilder.build());
            try {
                HttpResponse httpResponse = this.cosHttpClient.execute((HttpUriRequest)httpPost);
                int statusCode = httpResponse.getStatusLine().getStatusCode();
                if (statusCode == 200 || statusCode == 400) {
                    String string = responseStr = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
                    return string;
                }
                String errMsg = this.getErrorHttpResponseMsg("sendFileRequest", url, httpResponse.getStatusLine());
                LOG.error(errMsg);
                JSONObject errorRet = new JSONObject();
                errorRet.put("code", -2);
                errorRet.put("message", (Object)errMsg);
                String string = errorRet.toString();
                return string;
            }
            catch (IOException | ParseException e) {
                if (++retry != 3) continue;
                LOG.error("sendFileRequest occur a error: {}", (Object)e.toString());
                JSONObject errorRet = new JSONObject();
                errorRet.put("code", -2);
                errorRet.put("message", (Object)e.toString());
                responseStr = errorRet.toString();
            }
            finally {
                httpPost.releaseConnection();
            }
        }
        return responseStr;
    }

    private void setTimeout(HttpRequestBase httpRequest, int timeout) {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(timeout * 1000).setConnectTimeout(timeout * 1000).build();
        httpRequest.setConfig(requestConfig);
    }

    private void setHeaders(HttpMessage message, Map<String, String> headers) {
        message.setHeader("Accept", "*/*");
        message.setHeader("Connection", "Keep-Alive");
        message.setHeader("User-Agent", "qcloud-java-sdk");
        if (headers != null) {
            for (String headerKey : headers.keySet()) {
                message.setHeader(headerKey, headers.get(headerKey));
            }
        }
    }

    public void shutdown() {
        this.idleMonitor.shutdown();
    }
}

