/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cosapi.sign;

import com.qcloud.cosapi.sign.CommonCodecUtils;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sign {
    private static Logger LOG = LoggerFactory.getLogger(Sign.class);

    private static String appSignature(int appId, String secretId, String secretKey, long expired, String fileId, String bucketName) {
        if (secretId == null || secretKey == null || fileId == null || bucketName == null) {
            LOG.error("appSignature exist null param!");
            return "-1";
        }
        long now = System.currentTimeMillis() / 1000L;
        int rdm = Math.abs(new Random().nextInt());
        String plainText = "a=" + appId + "&k=" + secretId + "&e=" + expired + "&t=" + now + "&r=" + rdm + "&f=" + fileId + "&b=" + bucketName;
        byte[] hmacDigest = CommonCodecUtils.HmacSha1(plainText, secretKey);
        byte[] signContent = new byte[hmacDigest.length + plainText.getBytes().length];
        System.arraycopy(hmacDigest, 0, signContent, 0, hmacDigest.length);
        System.arraycopy(plainText.getBytes(), 0, signContent, hmacDigest.length, plainText.getBytes().length);
        return CommonCodecUtils.Base64Encode(signContent);
    }

    public static String appSignature(int appId, String secretId, String secretKey, long expired, String bucketName) {
        return Sign.appSignature(appId, secretId, secretKey, expired, "", bucketName);
    }

    public static String appSignatureOnce(int appId, String secretId, String secretKey, String remotePath, String bucketName) {
        String fileId = "/" + appId + "/" + bucketName + remotePath;
        return Sign.appSignature(appId, secretId, secretKey, 0L, fileId, bucketName);
    }
}

