/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.fasterxml.jackson.databind.type;

import com.signalfx.shaded.fasterxml.jackson.core.type.TypeReference;
import com.signalfx.shaded.fasterxml.jackson.databind.JavaType;
import com.signalfx.shaded.fasterxml.jackson.databind.type.ArrayType;
import com.signalfx.shaded.fasterxml.jackson.databind.type.ClassKey;
import com.signalfx.shaded.fasterxml.jackson.databind.type.CollectionLikeType;
import com.signalfx.shaded.fasterxml.jackson.databind.type.CollectionType;
import com.signalfx.shaded.fasterxml.jackson.databind.type.HierarchicType;
import com.signalfx.shaded.fasterxml.jackson.databind.type.MapLikeType;
import com.signalfx.shaded.fasterxml.jackson.databind.type.MapType;
import com.signalfx.shaded.fasterxml.jackson.databind.type.SimpleType;
import com.signalfx.shaded.fasterxml.jackson.databind.type.TypeBindings;
import com.signalfx.shaded.fasterxml.jackson.databind.type.TypeModifier;
import com.signalfx.shaded.fasterxml.jackson.databind.type.TypeParser;
import com.signalfx.shaded.fasterxml.jackson.databind.util.ArrayBuilders;
import com.signalfx.shaded.fasterxml.jackson.databind.util.LRUMap;
import java.io.Serializable;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TypeFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final JavaType[] NO_TYPES = new JavaType[0];
    protected static final TypeFactory instance = new TypeFactory();
    protected static final SimpleType CORE_TYPE_STRING = new SimpleType(String.class);
    protected static final SimpleType CORE_TYPE_BOOL = new SimpleType(Boolean.TYPE);
    protected static final SimpleType CORE_TYPE_INT = new SimpleType(Integer.TYPE);
    protected static final SimpleType CORE_TYPE_LONG = new SimpleType(Long.TYPE);
    protected final LRUMap<ClassKey, JavaType> _typeCache = new LRUMap(16, 100);
    protected transient HierarchicType _cachedHashMapType;
    protected transient HierarchicType _cachedArrayListType;
    protected final TypeModifier[] _modifiers;
    protected final TypeParser _parser;

    private TypeFactory() {
        this._parser = new TypeParser(this);
        this._modifiers = null;
    }

    protected TypeFactory(TypeParser typeParser, TypeModifier[] typeModifierArray) {
        this._parser = typeParser;
        this._modifiers = typeModifierArray;
    }

    public TypeFactory withModifier(TypeModifier typeModifier) {
        if (this._modifiers == null) {
            return new TypeFactory(this._parser, new TypeModifier[]{typeModifier});
        }
        return new TypeFactory(this._parser, ArrayBuilders.insertInListNoDup(this._modifiers, typeModifier));
    }

    public static TypeFactory defaultInstance() {
        return instance;
    }

    public static JavaType unknownType() {
        return TypeFactory.defaultInstance()._unknownType();
    }

    public static Class<?> rawClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        return TypeFactory.defaultInstance().constructType(type).getRawClass();
    }

    public JavaType constructSpecializedType(JavaType javaType, Class<?> clazz) {
        if (javaType instanceof SimpleType && (clazz.isArray() || Map.class.isAssignableFrom(clazz) || Collection.class.isAssignableFrom(clazz))) {
            if (!javaType.getRawClass().isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Class " + clazz.getClass().getName() + " not subtype of " + javaType);
            }
            JavaType javaType2 = this._fromClass(clazz, new TypeBindings(this, javaType.getRawClass()));
            Object t = javaType.getValueHandler();
            if (t != null) {
                javaType2 = javaType2.withValueHandler(t);
            }
            if ((t = javaType.getTypeHandler()) != null) {
                javaType2 = javaType2.withTypeHandler(t);
            }
            return javaType2;
        }
        return javaType.narrowBy(clazz);
    }

    public JavaType constructFromCanonical(String string) throws IllegalArgumentException {
        return this._parser.parse(string);
    }

    public JavaType[] findTypeParameters(JavaType javaType, Class<?> clazz) {
        Class<?> clazz2 = javaType.getRawClass();
        if (clazz2 == clazz) {
            int n = javaType.containedTypeCount();
            if (n == 0) {
                return null;
            }
            JavaType[] javaTypeArray = new JavaType[n];
            for (int i = 0; i < n; ++i) {
                javaTypeArray[i] = javaType.containedType(i);
            }
            return javaTypeArray;
        }
        return this.findTypeParameters(clazz2, clazz, new TypeBindings(this, javaType));
    }

    public JavaType[] findTypeParameters(Class<?> clazz, Class<?> clazz2) {
        return this.findTypeParameters(clazz, clazz2, new TypeBindings(this, clazz));
    }

    public JavaType[] findTypeParameters(Class<?> clazz, Class<?> clazz2, TypeBindings typeBindings) {
        HierarchicType hierarchicType = this._findSuperTypeChain(clazz, clazz2);
        if (hierarchicType == null) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " is not a subtype of " + clazz2.getName());
        }
        HierarchicType hierarchicType2 = hierarchicType;
        while (hierarchicType2.getSuperType() != null) {
            hierarchicType2 = hierarchicType2.getSuperType();
            Class<?> clazz3 = hierarchicType2.getRawClass();
            TypeBindings typeBindings2 = new TypeBindings(this, clazz3);
            if (hierarchicType2.isGeneric()) {
                ParameterizedType parameterizedType = hierarchicType2.asGeneric();
                Type[] typeArray = parameterizedType.getActualTypeArguments();
                TypeVariable<Class<?>>[] typeVariableArray = clazz3.getTypeParameters();
                int n = typeArray.length;
                for (int i = 0; i < n; ++i) {
                    String string = typeVariableArray[i].getName();
                    JavaType javaType = this._constructType(typeArray[i], typeBindings);
                    typeBindings2.addBinding(string, javaType);
                }
            }
            typeBindings = typeBindings2;
        }
        if (!hierarchicType2.isGeneric()) {
            return null;
        }
        return typeBindings.typesAsArray();
    }

    public JavaType moreSpecificType(JavaType javaType, JavaType javaType2) {
        Class<?> clazz;
        if (javaType == null) {
            return javaType2;
        }
        if (javaType2 == null) {
            return javaType;
        }
        Class<?> clazz2 = javaType.getRawClass();
        if (clazz2 == (clazz = javaType2.getRawClass())) {
            return javaType;
        }
        if (clazz2.isAssignableFrom(clazz)) {
            return javaType2;
        }
        return javaType;
    }

    public JavaType constructType(Type type) {
        return this._constructType(type, null);
    }

    public JavaType constructType(Type type, TypeBindings typeBindings) {
        return this._constructType(type, typeBindings);
    }

    public JavaType constructType(TypeReference<?> typeReference) {
        return this._constructType(typeReference.getType(), null);
    }

    public JavaType constructType(Type type, Class<?> clazz) {
        TypeBindings typeBindings = clazz == null ? null : new TypeBindings(this, clazz);
        return this._constructType(type, typeBindings);
    }

    public JavaType constructType(Type type, JavaType javaType) {
        TypeBindings typeBindings = javaType == null ? null : new TypeBindings(this, javaType);
        return this._constructType(type, typeBindings);
    }

    protected JavaType _constructType(Type type, TypeBindings typeBindings) {
        JavaType javaType;
        if (type instanceof Class) {
            TypeModifier[] typeModifierArray = (TypeModifier[])type;
            javaType = this._fromClass((Class<?>)typeModifierArray, typeBindings);
        } else if (type instanceof ParameterizedType) {
            javaType = this._fromParamType((ParameterizedType)type, typeBindings);
        } else {
            if (type instanceof JavaType) {
                return (JavaType)type;
            }
            if (type instanceof GenericArrayType) {
                javaType = this._fromArrayType((GenericArrayType)type, typeBindings);
            } else if (type instanceof TypeVariable) {
                javaType = this._fromVariable((TypeVariable)type, typeBindings);
            } else if (type instanceof WildcardType) {
                javaType = this._fromWildcard((WildcardType)type, typeBindings);
            } else {
                throw new IllegalArgumentException("Unrecognized Type: " + (type == null ? "[null]" : type.toString()));
            }
        }
        if (this._modifiers != null && !javaType.isContainerType()) {
            for (TypeModifier typeModifier : this._modifiers) {
                javaType = typeModifier.modifyType(javaType, type, typeBindings, this);
            }
        }
        return javaType;
    }

    public ArrayType constructArrayType(Class<?> clazz) {
        return ArrayType.construct(this._constructType(clazz, null), null, null);
    }

    public ArrayType constructArrayType(JavaType javaType) {
        return ArrayType.construct(javaType, null, null);
    }

    public CollectionType constructCollectionType(Class<? extends Collection> clazz, Class<?> clazz2) {
        return CollectionType.construct(clazz, this.constructType(clazz2));
    }

    public CollectionType constructCollectionType(Class<? extends Collection> clazz, JavaType javaType) {
        return CollectionType.construct(clazz, javaType);
    }

    public CollectionLikeType constructCollectionLikeType(Class<?> clazz, Class<?> clazz2) {
        return CollectionLikeType.construct(clazz, this.constructType(clazz2));
    }

    public CollectionLikeType constructCollectionLikeType(Class<?> clazz, JavaType javaType) {
        return CollectionLikeType.construct(clazz, javaType);
    }

    public MapType constructMapType(Class<? extends Map> clazz, JavaType javaType, JavaType javaType2) {
        return MapType.construct(clazz, javaType, javaType2);
    }

    public MapType constructMapType(Class<? extends Map> clazz, Class<?> clazz2, Class<?> clazz3) {
        return MapType.construct(clazz, this.constructType(clazz2), this.constructType(clazz3));
    }

    public MapLikeType constructMapLikeType(Class<?> clazz, JavaType javaType, JavaType javaType2) {
        return MapLikeType.construct(clazz, javaType, javaType2);
    }

    public MapLikeType constructMapLikeType(Class<?> clazz, Class<?> clazz2, Class<?> clazz3) {
        return MapType.construct(clazz, this.constructType(clazz2), this.constructType(clazz3));
    }

    public JavaType constructSimpleType(Class<?> clazz, JavaType[] javaTypeArray) {
        TypeVariable<Class<?>>[] typeVariableArray = clazz.getTypeParameters();
        if (typeVariableArray.length != javaTypeArray.length) {
            throw new IllegalArgumentException("Parameter type mismatch for " + clazz.getName() + ": expected " + typeVariableArray.length + " parameters, was given " + javaTypeArray.length);
        }
        String[] stringArray = new String[typeVariableArray.length];
        int n = typeVariableArray.length;
        for (int i = 0; i < n; ++i) {
            stringArray[i] = typeVariableArray[i].getName();
        }
        SimpleType simpleType = new SimpleType(clazz, stringArray, javaTypeArray, null, null, false);
        return simpleType;
    }

    public JavaType uncheckedSimpleType(Class<?> clazz) {
        return new SimpleType(clazz);
    }

    public JavaType constructParametricType(Class<?> clazz, Class<?> ... classArray) {
        int n = classArray.length;
        JavaType[] javaTypeArray = new JavaType[n];
        for (int i = 0; i < n; ++i) {
            javaTypeArray[i] = this._fromClass(classArray[i], null);
        }
        return this.constructParametricType(clazz, javaTypeArray);
    }

    public JavaType constructParametricType(Class<?> clazz, JavaType ... javaTypeArray) {
        JavaType javaType;
        if (clazz.isArray()) {
            if (javaTypeArray.length != 1) {
                throw new IllegalArgumentException("Need exactly 1 parameter type for arrays (" + clazz.getName() + ")");
            }
            javaType = this.constructArrayType(javaTypeArray[0]);
        } else if (Map.class.isAssignableFrom(clazz)) {
            if (javaTypeArray.length != 2) {
                throw new IllegalArgumentException("Need exactly 2 parameter types for Map types (" + clazz.getName() + ")");
            }
            javaType = this.constructMapType(clazz, javaTypeArray[0], javaTypeArray[1]);
        } else if (Collection.class.isAssignableFrom(clazz)) {
            if (javaTypeArray.length != 1) {
                throw new IllegalArgumentException("Need exactly 1 parameter type for Collection types (" + clazz.getName() + ")");
            }
            javaType = this.constructCollectionType(clazz, javaTypeArray[0]);
        } else {
            javaType = this.constructSimpleType(clazz, javaTypeArray);
        }
        return javaType;
    }

    public CollectionType constructRawCollectionType(Class<? extends Collection> clazz) {
        return CollectionType.construct(clazz, TypeFactory.unknownType());
    }

    public CollectionLikeType constructRawCollectionLikeType(Class<?> clazz) {
        return CollectionLikeType.construct(clazz, TypeFactory.unknownType());
    }

    public MapType constructRawMapType(Class<? extends Map> clazz) {
        return MapType.construct(clazz, TypeFactory.unknownType(), TypeFactory.unknownType());
    }

    public MapLikeType constructRawMapLikeType(Class<?> clazz) {
        return MapLikeType.construct(clazz, TypeFactory.unknownType(), TypeFactory.unknownType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JavaType _fromClass(Class<?> clazz, TypeBindings typeBindings) {
        JavaType javaType;
        if (clazz == String.class) {
            return CORE_TYPE_STRING;
        }
        if (clazz == Boolean.TYPE) {
            return CORE_TYPE_BOOL;
        }
        if (clazz == Integer.TYPE) {
            return CORE_TYPE_INT;
        }
        if (clazz == Long.TYPE) {
            return CORE_TYPE_LONG;
        }
        ClassKey classKey = new ClassKey(clazz);
        LRUMap<ClassKey, JavaType> lRUMap = this._typeCache;
        synchronized (lRUMap) {
            javaType = (JavaType)this._typeCache.get(classKey);
        }
        if (javaType != null) {
            return javaType;
        }
        javaType = clazz.isArray() ? ArrayType.construct(this._constructType(clazz.getComponentType(), null), null, null) : (clazz.isEnum() ? new SimpleType(clazz) : (Map.class.isAssignableFrom(clazz) ? this._mapType(clazz) : (Collection.class.isAssignableFrom(clazz) ? this._collectionType(clazz) : new SimpleType(clazz))));
        lRUMap = this._typeCache;
        synchronized (lRUMap) {
            this._typeCache.put(classKey, javaType);
        }
        return javaType;
    }

    protected JavaType _fromParameterizedClass(Class<?> clazz, List<JavaType> list) {
        if (clazz.isArray()) {
            return ArrayType.construct(this._constructType(clazz.getComponentType(), null), null, null);
        }
        if (clazz.isEnum()) {
            return new SimpleType(clazz);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            if (list.size() > 0) {
                JavaType javaType = list.get(0);
                JavaType javaType2 = list.size() >= 2 ? list.get(1) : this._unknownType();
                return MapType.construct(clazz, javaType, javaType2);
            }
            return this._mapType(clazz);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            if (list.size() >= 1) {
                return CollectionType.construct(clazz, list.get(0));
            }
            return this._collectionType(clazz);
        }
        if (list.size() == 0) {
            return new SimpleType(clazz);
        }
        JavaType[] javaTypeArray = list.toArray(new JavaType[list.size()]);
        return this.constructSimpleType(clazz, javaTypeArray);
    }

    protected JavaType _fromParamType(ParameterizedType parameterizedType, TypeBindings typeBindings) {
        JavaType[] javaTypeArray;
        int n;
        Class clazz = (Class)parameterizedType.getRawType();
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        int n2 = n = typeArray == null ? 0 : typeArray.length;
        if (n == 0) {
            javaTypeArray = NO_TYPES;
        } else {
            javaTypeArray = new JavaType[n];
            for (int i = 0; i < n; ++i) {
                javaTypeArray[i] = this._constructType(typeArray[i], typeBindings);
            }
        }
        if (Map.class.isAssignableFrom(clazz)) {
            JavaType javaType = this.constructSimpleType(clazz, javaTypeArray);
            JavaType[] javaTypeArray2 = this.findTypeParameters(javaType, Map.class);
            if (javaTypeArray2.length != 2) {
                throw new IllegalArgumentException("Could not find 2 type parameters for Map class " + clazz.getName() + " (found " + javaTypeArray2.length + ")");
            }
            return MapType.construct(clazz, javaTypeArray2[0], javaTypeArray2[1]);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            JavaType javaType = this.constructSimpleType(clazz, javaTypeArray);
            JavaType[] javaTypeArray3 = this.findTypeParameters(javaType, Collection.class);
            if (javaTypeArray3.length != 1) {
                throw new IllegalArgumentException("Could not find 1 type parameter for Collection class " + clazz.getName() + " (found " + javaTypeArray3.length + ")");
            }
            return CollectionType.construct(clazz, javaTypeArray3[0]);
        }
        if (n == 0) {
            return new SimpleType(clazz);
        }
        return this.constructSimpleType(clazz, javaTypeArray);
    }

    protected JavaType _fromArrayType(GenericArrayType genericArrayType, TypeBindings typeBindings) {
        JavaType javaType = this._constructType(genericArrayType.getGenericComponentType(), typeBindings);
        return ArrayType.construct(javaType, null, null);
    }

    protected JavaType _fromVariable(TypeVariable<?> typeVariable, TypeBindings typeBindings) {
        if (typeBindings == null) {
            return this._unknownType();
        }
        String string = typeVariable.getName();
        JavaType javaType = typeBindings.findType(string);
        if (javaType != null) {
            return javaType;
        }
        Type[] typeArray = typeVariable.getBounds();
        typeBindings._addPlaceholder(string);
        return this._constructType(typeArray[0], typeBindings);
    }

    protected JavaType _fromWildcard(WildcardType wildcardType, TypeBindings typeBindings) {
        return this._constructType(wildcardType.getUpperBounds()[0], typeBindings);
    }

    private JavaType _mapType(Class<?> clazz) {
        JavaType[] javaTypeArray = this.findTypeParameters(clazz, Map.class);
        if (javaTypeArray == null) {
            return MapType.construct(clazz, this._unknownType(), this._unknownType());
        }
        if (javaTypeArray.length != 2) {
            throw new IllegalArgumentException("Strange Map type " + clazz.getName() + ": can not determine type parameters");
        }
        return MapType.construct(clazz, javaTypeArray[0], javaTypeArray[1]);
    }

    private JavaType _collectionType(Class<?> clazz) {
        JavaType[] javaTypeArray = this.findTypeParameters(clazz, Collection.class);
        if (javaTypeArray == null) {
            return CollectionType.construct(clazz, this._unknownType());
        }
        if (javaTypeArray.length != 1) {
            throw new IllegalArgumentException("Strange Collection type " + clazz.getName() + ": can not determine type parameters");
        }
        return CollectionType.construct(clazz, javaTypeArray[0]);
    }

    protected JavaType _resolveVariableViaSubTypes(HierarchicType hierarchicType, String string, TypeBindings typeBindings) {
        if (hierarchicType != null && hierarchicType.isGeneric()) {
            TypeVariable<Class<?>>[] typeVariableArray = hierarchicType.getRawClass().getTypeParameters();
            int n = typeVariableArray.length;
            for (int i = 0; i < n; ++i) {
                TypeVariable<Class<?>> typeVariable = typeVariableArray[i];
                if (!string.equals(typeVariable.getName())) continue;
                Type type = hierarchicType.asGeneric().getActualTypeArguments()[i];
                if (type instanceof TypeVariable) {
                    return this._resolveVariableViaSubTypes(hierarchicType.getSubType(), ((TypeVariable)type).getName(), typeBindings);
                }
                return this._constructType(type, typeBindings);
            }
        }
        return this._unknownType();
    }

    protected JavaType _unknownType() {
        return new SimpleType(Object.class);
    }

    protected HierarchicType _findSuperTypeChain(Class<?> clazz, Class<?> clazz2) {
        if (clazz2.isInterface()) {
            return this._findSuperInterfaceChain(clazz, clazz2);
        }
        return this._findSuperClassChain(clazz, clazz2);
    }

    protected HierarchicType _findSuperClassChain(Type type, Class<?> clazz) {
        HierarchicType hierarchicType;
        HierarchicType hierarchicType2 = new HierarchicType(type);
        Class<?> clazz2 = hierarchicType2.getRawClass();
        if (clazz2 == clazz) {
            return hierarchicType2;
        }
        Type type2 = clazz2.getGenericSuperclass();
        if (type2 != null && (hierarchicType = this._findSuperClassChain(type2, clazz)) != null) {
            hierarchicType.setSubType(hierarchicType2);
            hierarchicType2.setSuperType(hierarchicType);
            return hierarchicType2;
        }
        return null;
    }

    protected HierarchicType _findSuperInterfaceChain(Type type, Class<?> clazz) {
        HierarchicType hierarchicType = new HierarchicType(type);
        Class<?> clazz2 = hierarchicType.getRawClass();
        if (clazz2 == clazz) {
            return new HierarchicType(type);
        }
        if (clazz2 == HashMap.class && clazz == Map.class) {
            return this._hashMapSuperInterfaceChain(hierarchicType);
        }
        if (clazz2 == ArrayList.class && clazz == List.class) {
            return this._arrayListSuperInterfaceChain(hierarchicType);
        }
        return this._doFindSuperInterfaceChain(hierarchicType, clazz);
    }

    protected HierarchicType _doFindSuperInterfaceChain(HierarchicType hierarchicType, Class<?> clazz) {
        HierarchicType hierarchicType2;
        Object object;
        Class<?> clazz2 = hierarchicType.getRawClass();
        Type[] typeArray = clazz2.getGenericInterfaces();
        if (typeArray != null) {
            object = typeArray;
            int n = ((Type[])object).length;
            for (int i = 0; i < n; ++i) {
                Type type = object[i];
                HierarchicType hierarchicType3 = this._findSuperInterfaceChain(type, clazz);
                if (hierarchicType3 == null) continue;
                hierarchicType3.setSubType(hierarchicType);
                hierarchicType.setSuperType(hierarchicType3);
                return hierarchicType;
            }
        }
        if ((object = clazz2.getGenericSuperclass()) != null && (hierarchicType2 = this._findSuperInterfaceChain((Type)object, clazz)) != null) {
            hierarchicType2.setSubType(hierarchicType);
            hierarchicType.setSuperType(hierarchicType2);
            return hierarchicType;
        }
        return null;
    }

    protected synchronized HierarchicType _hashMapSuperInterfaceChain(HierarchicType hierarchicType) {
        HierarchicType hierarchicType2;
        if (this._cachedHashMapType == null) {
            hierarchicType2 = hierarchicType.deepCloneWithoutSubtype();
            this._doFindSuperInterfaceChain(hierarchicType2, Map.class);
            this._cachedHashMapType = hierarchicType2.getSuperType();
        }
        hierarchicType2 = this._cachedHashMapType.deepCloneWithoutSubtype();
        hierarchicType.setSuperType(hierarchicType2);
        hierarchicType2.setSubType(hierarchicType);
        return hierarchicType;
    }

    protected synchronized HierarchicType _arrayListSuperInterfaceChain(HierarchicType hierarchicType) {
        HierarchicType hierarchicType2;
        if (this._cachedArrayListType == null) {
            hierarchicType2 = hierarchicType.deepCloneWithoutSubtype();
            this._doFindSuperInterfaceChain(hierarchicType2, List.class);
            this._cachedArrayListType = hierarchicType2.getSuperType();
        }
        hierarchicType2 = this._cachedArrayListType.deepCloneWithoutSubtype();
        hierarchicType.setSuperType(hierarchicType2);
        hierarchicType2.setSubType(hierarchicType);
        return hierarchicType;
    }
}

