/*
 * Decompiled with CFR 0.152.
 */
package retrofit.converter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import org.simpleframework.xml.Serializer;
import org.simpleframework.xml.core.Persister;
import retrofit.converter.ConversionException;
import retrofit.converter.Converter;
import retrofit.mime.TypedByteArray;
import retrofit.mime.TypedInput;
import retrofit.mime.TypedOutput;

public class SimpleXMLConverter
implements Converter {
    private static final String CHARSET = "UTF-8";
    private static final String MIME_TYPE = "application/xml; charset=UTF-8";
    private final Serializer serializer;

    public SimpleXMLConverter() {
        this((Serializer)new Persister());
    }

    public SimpleXMLConverter(Serializer serializer) {
        this.serializer = serializer;
    }

    public Object fromBody(TypedInput body, Type type) throws ConversionException {
        try {
            return this.serializer.read((Class)type, body.in());
        }
        catch (Exception e) {
            throw new ConversionException((Throwable)e);
        }
    }

    public TypedOutput toBody(Object source) {
        OutputStreamWriter osw = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            osw = new OutputStreamWriter((OutputStream)bos, CHARSET);
            this.serializer.write(source, (Writer)osw);
            osw.flush();
            TypedByteArray typedByteArray = new TypedByteArray(MIME_TYPE, bos.toByteArray());
            return typedByteArray;
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        finally {
            try {
                if (osw != null) {
                    osw.close();
                }
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

