/*
 * Decompiled with CFR 0.152.
 */
package com.upyun;

import com.upyun.UpException;
import com.upyun.UpYunUtils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseUploader {
    static final String AUTHORIZATION = "Authorization";
    static final int BLOCK_SIZE = 0x100000;
    final String DATE = "Date";
    static final String CONTENT_MD5 = "Content-MD5";
    static final String CONTENT_TYPE = "CContent-Type";
    static final String CONTENT_SECRET = "Content-Secret";
    static final String X_Upyun_Meta_X = "X-Upyun-Meta-X";
    static final String X_UPYUN_MULTI_DISORDER = "X-Upyun-Multi-Disorder";
    static final String X_UPYUN_MULTI_STAGE = "X-Upyun-Multi-Stage";
    static final String X_UPYUN_MULTI_TYPE = "X-Upyun-Multi-Type";
    static final String X_UPYUN_MULTI_LENGTH = "X-Upyun-Multi-Length";
    static final String X_UPYUN_MULTI_UUID = "X-Upyun-Multi-UUID";
    static final String X_UPYUN_PART_ID = "X-Upyun-Part-ID";
    static final String X_UPYUN_NEXT_PART_ID = "X-Upyun-Next-Part-ID";
    static final String HOST = "https://v0.api.upyun.com";
    Map<String, String> params;
    volatile boolean paused;
    String uuid;
    String uri;
    OkHttpClient mClient;
    File mFile;
    RandomAccessFile randomAccessFile;
    boolean checkMD5;
    String bucketName;
    String userName;
    String password;
    int timeout = 20;
    String url;
    OnProgressListener onProgressListener;
    int totalBlock;

    public BaseUploader(String bucketName, String userName, String password) {
        this.bucketName = bucketName;
        this.userName = userName;
        this.password = UpYunUtils.md5(password);
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void pause() {
        this.paused = true;
    }

    void init(String filePath, String uploadPath, Map<String, String> params) throws IOException {
        this.paused = false;
        if (params == null) {
            params = new HashMap<String, String>();
        }
        this.params = params;
        this.mFile = new File(filePath);
        this.totalBlock = (int)Math.ceil((double)this.mFile.length() / 1048576.0 + 2.0);
        this.url = HOST + UpYunUtils.formatPath(this.bucketName, uploadPath);
        this.uri = HttpUrl.get((String)this.url).encodedPath();
        this.mClient = new OkHttpClient.Builder().connectTimeout((long)this.timeout, TimeUnit.SECONDS).readTimeout((long)this.timeout, TimeUnit.SECONDS).writeTimeout((long)this.timeout, TimeUnit.SECONDS).build();
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setCheckMD5(boolean checkMD5) {
        this.checkMD5 = checkMD5;
    }

    public void setOnProgressListener(OnProgressListener onProgressListener) {
        this.onProgressListener = onProgressListener;
    }

    boolean startUpload() throws IOException, UpException {
        if (this.paused) {
            throw new UpException("upload paused");
        }
        if (this.uuid == null) {
            RequestBody requestBody = RequestBody.create(null, (String)"");
            String date = UpYunUtils.getGMTDate();
            String md5 = null;
            if (this.checkMD5) {
                md5 = UpYunUtils.md5("");
            }
            String sign = UpYunUtils.sign("PUT", date, this.uri, this.userName, this.password, md5).trim();
            Request.Builder builder = new Request.Builder().url(this.url).header("Date", date).header(AUTHORIZATION, sign).header(X_UPYUN_MULTI_STAGE, "initiate").header(X_UPYUN_MULTI_TYPE, "application/octet-stream").header(X_UPYUN_MULTI_LENGTH, this.mFile.length() + "").header("User-Agent", "upyun-java-sdk/4.2.2").put(requestBody);
            if (this.params != null) {
                for (Map.Entry<String, String> entry : this.params.entrySet()) {
                    builder.header(entry.getKey(), entry.getValue());
                }
            }
            if (md5 != null) {
                builder.header(CONTENT_MD5, md5);
            }
            this.callRequest(builder.build(), 1);
        }
        if (this.randomAccessFile == null) {
            this.randomAccessFile = new RandomAccessFile(this.mFile, "r");
        }
        return this.processUpload();
    }

    abstract boolean processUpload() throws IOException, UpException;

    abstract boolean completeUpload() throws IOException, UpException;

    void completeRequest() throws UpException, IOException {
        if (this.randomAccessFile != null) {
            this.randomAccessFile.close();
            this.randomAccessFile = null;
        }
        RequestBody requestBody = RequestBody.create(null, (String)"");
        String date = UpYunUtils.getGMTDate();
        String md5 = null;
        if (this.checkMD5) {
            md5 = UpYunUtils.md5("");
        }
        String sign = UpYunUtils.sign("PUT", date, this.uri, this.userName, this.password, md5).trim();
        Request.Builder builder = new Request.Builder().url(this.url).header("Date", date).header(AUTHORIZATION, sign).header(X_UPYUN_MULTI_STAGE, "complete").header(X_UPYUN_MULTI_UUID, this.uuid).header("User-Agent", "upyun-java-sdk/4.2.2").put(requestBody);
        if (md5 != null) {
            builder.header(CONTENT_MD5, md5);
        }
        this.callRequest(builder.build(), this.totalBlock);
    }

    Response callRequest(Request request, int index) throws IOException, UpException {
        Response response = this.mClient.newCall(request).execute();
        if (!response.isSuccessful()) {
            throw new UpException(response.body().string());
        }
        if (this.onProgressListener != null) {
            this.onProgressListener.onProgress(index, this.totalBlock);
        }
        this.uuid = response.header(X_UPYUN_MULTI_UUID, "");
        return response;
    }

    byte[] readBlockByIndex(long index) throws IOException {
        byte[] block = new byte[0x100000];
        int readedSize = 0;
        long offset = index * 0x100000L;
        this.randomAccessFile.seek(offset);
        readedSize = this.randomAccessFile.read(block, 0, 0x100000);
        if (readedSize < 0x100000) {
            byte[] notFullBlock = new byte[readedSize];
            System.arraycopy(block, 0, notFullBlock, 0, readedSize);
            return notFullBlock;
        }
        return block;
    }

    public static interface OnProgressListener {
        public void onProgress(int var1, int var2);
    }
}

