/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.notify;

import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.notify.Notifier;
import de.codecentric.boot.admin.server.services.AbstractEventHandler;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class NotificationTrigger
extends AbstractEventHandler<InstanceEvent> {
    private final Notifier notifier;

    public NotificationTrigger(Notifier notifier, Publisher<InstanceEvent> publisher) {
        super(publisher, InstanceEvent.class);
        this.notifier = notifier;
    }

    @Override
    protected Publisher<Void> handle(Flux<InstanceEvent> publisher) {
        Scheduler scheduler = Schedulers.newSingle((String)"notifications");
        return publisher.subscribeOn(scheduler).flatMap(this::sendNotifications).doFinally(s -> scheduler.dispose());
    }

    protected Mono<Void> sendNotifications(InstanceEvent event) {
        return this.notifier.notify(event);
    }
}

