/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.client.config;

import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;

public class SpringBootAdminClientEnabledCondition
extends SpringBootCondition {
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata annotatedTypeMetadata) {
        if (!this.isEnabled(context.getEnvironment())) {
            return ConditionOutcome.noMatch((String)"Spring Boot Client is disabled, because 'spring.boot.admin.client.enabled' is false.");
        }
        if (this.isUrlEmpty(context.getEnvironment())) {
            return ConditionOutcome.noMatch((String)"Spring Boot Client is disabled, because 'spring.boot.admin.url' is empty.");
        }
        return ConditionOutcome.match();
    }

    private boolean isEnabled(Environment env) {
        RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)env, "spring.boot.admin.client.");
        return (Boolean)resolver.getProperty("enabled", Boolean.class, (Object)Boolean.TRUE);
    }

    private boolean isUrlEmpty(Environment env) {
        RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)env, "spring.boot.admin.");
        return StringUtils.isEmpty((Object)resolver.getProperty("url", ""));
    }
}

