/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.serialization;

import de.ruedigermoeller.serialization.FSTClazzInfo;
import de.ruedigermoeller.serialization.FSTConfiguration;
import de.ruedigermoeller.serialization.FSTObjectOutput;
import de.ruedigermoeller.serialization.FSTObjectSerializer;
import java.io.IOException;
import java.io.OutputStream;

public class FSTObjectOutputNoShared
extends FSTObjectOutput {
    public FSTObjectOutputNoShared(OutputStream out) {
        super(out);
    }

    public FSTObjectOutputNoShared(OutputStream out, FSTConfiguration conf) {
        super(out, conf);
        conf.setShareReferences(false);
    }

    public FSTObjectOutputNoShared(FSTConfiguration conf) {
        super(conf);
        conf.setShareReferences(false);
    }

    public FSTObjectOutputNoShared() {
    }

    @Override
    protected void writeObjectHeader(FSTClazzInfo clsInfo, FSTClazzInfo.FSTFieldInfo referencee, Object toWrite) throws IOException {
        if (toWrite.getClass() == referencee.getType()) {
            this.writeFByte(-3);
        } else {
            Class[] possibleClasses = referencee.getPossibleClasses();
            if (possibleClasses == null) {
                this.writeFByte(0);
                this.writeClass(clsInfo);
            } else {
                int length = possibleClasses.length;
                for (int j = 0; j < length; ++j) {
                    Class possibleClass = possibleClasses[j];
                    if (possibleClass != toWrite.getClass()) continue;
                    this.writeFByte(j + 1);
                    return;
                }
                this.writeFByte(0);
                this.writeClass(clsInfo);
            }
        }
    }

    @Override
    protected void writeObjectWithContext(FSTClazzInfo.FSTFieldInfo referencee, Object toWrite) throws IOException {
        if (toWrite == null) {
            this.writeFByte(-1);
            return;
        }
        Class<?> clazz = toWrite.getClass();
        if (clazz == String.class) {
            String[] oneOf = referencee.getOneOf();
            if (oneOf != null) {
                for (int i = 0; i < oneOf.length; ++i) {
                    String s = oneOf[i];
                    if (!s.equals(toWrite)) continue;
                    this.writeFByte(-18);
                    this.writeFByte(i);
                    return;
                }
            }
            this.writeFByte(-4);
            this.writeStringUTF((String)toWrite);
            return;
        }
        if (clazz == Integer.class) {
            this.writeFByte(-9);
            this.writeCInt((Integer)toWrite);
            return;
        }
        if (clazz == Long.class) {
            this.writeFByte(-10);
            this.writeCLong((Long)toWrite);
            return;
        }
        if (clazz == Boolean.class) {
            this.writeFByte((Boolean)toWrite != false ? -16 : -17);
            return;
        }
        if (clazz.isArray()) {
            this.writeFByte(-5);
            this.writeArray(referencee, toWrite);
            return;
        }
        if (referencee.getType() != null && referencee.getType().isEnum() || toWrite instanceof Enum) {
            this.writeFByte(-6);
            Class<?> c = toWrite.getClass();
            boolean isEnumClass = c.isEnum();
            if (!isEnumClass) {
                while (c != null && !c.isEnum()) {
                    c = toWrite.getClass().getEnclosingClass();
                }
                if (c == null) {
                    throw new RuntimeException("Can't handle this enum: " + toWrite.getClass());
                }
                this.writeClass(c);
            } else {
                this.writeClass(this.getFstClazzInfo(referencee, toWrite.getClass()));
            }
            this.writeCInt(((Enum)toWrite).ordinal());
            return;
        }
        FSTClazzInfo serializationInfo = this.getFstClazzInfo(referencee, clazz);
        FSTObjectSerializer ser = serializationInfo.getSer();
        this.writeObjectHeader(serializationInfo, referencee, toWrite);
        if (ser == null) {
            this.defaultWriteObject(toWrite, serializationInfo);
        } else {
            ser.writeObject(this, toWrite, serializationInfo, referencee, this.written);
        }
    }

    @Override
    public void resetForReUse(OutputStream out) {
        if (this.closed) {
            throw new RuntimeException("Can't reuse closed stream");
        }
        this.reset();
        if (out != null) {
            this.buffout.setOutstream(out);
        } else {
            this.out = this.buffout;
        }
        this.clnames.clear();
    }

    @Override
    public void resetForReUse(byte[] out) {
        if (this.closed) {
            throw new RuntimeException("Can't reuse closed stream");
        }
        this.reset();
        this.out = this.buffout;
        this.buffout.reset(out);
        this.clnames.clear();
    }
}

