/*
 * Decompiled with CFR 0.152.
 */
package dev.failsafe;

import dev.failsafe.ExecutionImpl;
import dev.failsafe.spi.ExecutionResult;
import java.time.Duration;

public interface ExecutionContext<R> {
    public Duration getElapsedTime();

    public Duration getElapsedAttemptTime();

    public int getAttemptCount();

    public int getExecutionCount();

    public <T extends Throwable> T getLastFailure();

    public R getLastResult();

    public R getLastResult(R var1);

    public Duration getStartTime();

    public boolean isCancelled();

    public boolean isFirstAttempt();

    public boolean isRetry();

    public static <R> ExecutionContext<R> ofResult(R result) {
        return new ExecutionImpl<R>(ExecutionResult.success(result));
    }

    public static <R> ExecutionContext<R> ofFailure(Throwable failure) {
        return new ExecutionImpl(ExecutionResult.failure(failure));
    }
}

