/*
 * Decompiled with CFR 0.152.
 */
package dev.failsafe;

import dev.failsafe.Policy;
import dev.failsafe.internal.util.Assert;
import dev.failsafe.spi.ExecutionInternal;
import dev.failsafe.spi.ExecutionResult;
import dev.failsafe.spi.PolicyExecutor;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicInteger;

class ExecutionImpl<R>
implements ExecutionInternal<R> {
    final List<PolicyExecutor<R>> policyExecutors;
    private volatile Duration startTime;
    private AtomicInteger attempts;
    private AtomicInteger executions;
    private final ExecutionResult<R> previousResult;
    volatile ExecutionResult<R> result;
    volatile Duration attemptStartTime;
    volatile int cancelledIndex = Integer.MIN_VALUE;
    private volatile boolean preExecuted;
    volatile boolean attemptRecorded;
    volatile boolean completed;

    ExecutionImpl(List<? extends Policy<R>> policies) {
        this.policyExecutors = new ArrayList<PolicyExecutor<R>>(policies.size());
        this.startTime = Duration.ZERO;
        this.attemptStartTime = Duration.ZERO;
        this.attempts = new AtomicInteger();
        this.executions = new AtomicInteger();
        this.previousResult = null;
        ListIterator<Policy<R>> policyIterator = policies.listIterator(policies.size());
        int i = 0;
        while (policyIterator.hasPrevious()) {
            Policy<R> policy = Assert.notNull(policyIterator.previous(), "policies");
            PolicyExecutor<R> policyExecutor = policy.toExecutor(i);
            this.policyExecutors.add(policyExecutor);
            ++i;
        }
    }

    ExecutionImpl(ExecutionImpl<R> execution) {
        this.policyExecutors = execution.policyExecutors;
        this.startTime = execution.startTime;
        this.attempts = execution.attempts;
        this.executions = execution.executions;
        this.previousResult = execution.result;
    }

    ExecutionImpl(ExecutionResult<R> previousResult) {
        this.policyExecutors = null;
        this.previousResult = previousResult;
    }

    @Override
    public ExecutionResult<R> getResult() {
        return this.result;
    }

    @Override
    public synchronized void preExecute() {
        if (!this.preExecuted) {
            this.attemptStartTime = Duration.ofNanos(System.nanoTime());
            if (this.startTime == Duration.ZERO) {
                this.startTime = this.attemptStartTime;
            }
            this.preExecuted = true;
        }
    }

    @Override
    public boolean isPreExecuted() {
        return this.preExecuted;
    }

    @Override
    public synchronized void recordAttempt() {
        if (!this.attemptRecorded) {
            this.attempts.incrementAndGet();
            this.attemptRecorded = true;
        }
    }

    @Override
    public synchronized void record(ExecutionResult<R> result) {
        if (this.preExecuted && !this.attemptRecorded) {
            this.recordAttempt();
            this.executions.incrementAndGet();
            this.result = result;
        }
    }

    synchronized ExecutionResult<R> postExecute(ExecutionResult<R> result) {
        Assert.state(!this.completed, "Execution has already been completed", new Object[0]);
        this.record(result);
        boolean allComplete = true;
        for (PolicyExecutor<R> policyExecutor : this.policyExecutors) {
            result = policyExecutor.postExecute(this, result);
            allComplete = allComplete && result.isComplete();
        }
        this.completed = allComplete;
        return result;
    }

    @Override
    public void cancel() {
        this.cancelledIndex = Integer.MAX_VALUE;
    }

    @Override
    public void cancel(PolicyExecutor<R> policyExecutor) {
        this.cancelledIndex = policyExecutor.getPolicyIndex();
    }

    @Override
    public boolean isCancelled() {
        return this.cancelledIndex > Integer.MIN_VALUE;
    }

    @Override
    public boolean isCancelled(PolicyExecutor<R> policyExecutor) {
        return this.cancelledIndex > policyExecutor.getPolicyIndex();
    }

    @Override
    public Duration getElapsedTime() {
        return Duration.ofNanos(System.nanoTime() - this.startTime.toNanos());
    }

    @Override
    public Duration getElapsedAttemptTime() {
        return Duration.ofNanos(System.nanoTime() - this.attemptStartTime.toNanos());
    }

    @Override
    public int getAttemptCount() {
        return this.attempts.get();
    }

    @Override
    public int getExecutionCount() {
        return this.executions.get();
    }

    @Override
    public <T extends Throwable> T getLastFailure() {
        ExecutionResult<R> r = this.result != null ? this.result : this.previousResult;
        return (T)(r == null ? null : r.getFailure());
    }

    @Override
    public R getLastResult() {
        ExecutionResult<R> r = this.result != null ? this.result : this.previousResult;
        return r == null ? null : (R)r.getResult();
    }

    @Override
    public R getLastResult(R defaultValue) {
        ExecutionResult<R> r = this.result != null ? this.result : this.previousResult;
        return r == null ? defaultValue : r.getResult();
    }

    @Override
    public Duration getStartTime() {
        return this.startTime;
    }

    @Override
    public boolean isFirstAttempt() {
        return this.attempts.get() == (!this.attemptRecorded ? 0 : 1);
    }

    @Override
    public boolean isRetry() {
        return this.attempts.get() > (!this.attemptRecorded ? 0 : 1);
    }

    public String toString() {
        return "[attempts=" + this.attempts + ", executions=" + this.executions + ", lastResult=" + this.getLastResult() + ", lastFailure=" + this.getLastFailure() + ']';
    }
}

