/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver;

import fr.brouillard.oss.jgitver.BranchingPolicy;
import fr.brouillard.oss.jgitver.Lambdas;
import fr.brouillard.oss.jgitver.Version;
import fr.brouillard.oss.jgitver.impl.Commit;
import fr.brouillard.oss.jgitver.impl.ConfigurableVersionStrategy;
import fr.brouillard.oss.jgitver.impl.GitUtils;
import fr.brouillard.oss.jgitver.impl.MavenVersionStrategy;
import fr.brouillard.oss.jgitver.impl.VersionNamingConfiguration;
import fr.brouillard.oss.jgitver.impl.VersionStrategy;
import fr.brouillard.oss.jgitver.metadata.MetadataHolder;
import fr.brouillard.oss.jgitver.metadata.MetadataProvider;
import fr.brouillard.oss.jgitver.metadata.Metadatas;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

public class GitVersionCalculator
implements AutoCloseable,
MetadataProvider {
    private MetadataHolder metadatas;
    private Repository repository;
    private boolean mavenLike = false;
    private boolean autoIncrementPatch = false;
    private boolean useDistance = true;
    private boolean useGitCommitId = false;
    private boolean useDirty = false;
    private int gitCommitIdLength = 8;
    private List<BranchingPolicy> qualifierBranchingPolicies;
    private boolean useDefaultBranchingPolicy = true;
    private File gitRepositoryLocation;
    private final SimpleDateFormat dtfmt;
    private Pattern findTagVersionPattern = VersionNamingConfiguration.DEFAULT_FIND_TAG_VERSION_PATTERN;

    private GitVersionCalculator(File gitRepositoryLocation) throws IOException {
        this.gitRepositoryLocation = gitRepositoryLocation;
        this.dtfmt = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy Z", Locale.US);
        this.setNonQualifierBranches("master");
    }

    public static GitVersionCalculator location(File gitRepositoryLocation) {
        try {
            GitVersionCalculator gvc = new GitVersionCalculator(gitRepositoryLocation);
            return gvc;
        }
        catch (IOException ex) {
            throw new IllegalStateException("cannot open git repository under: " + gitRepositoryLocation, ex);
        }
    }

    private Repository openRepository() throws IOException {
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        return ((FileRepositoryBuilder)builder.findGitDir(this.gitRepositoryLocation)).build();
    }

    public Version getVersionObject() {
        this.metadatas = new MetadataHolder();
        try {
            this.repository = this.openRepository();
        }
        catch (Exception ex) {
            return Version.NOT_GIT_VERSION;
        }
        try (Git git = new Git(this.repository);){
            VersionStrategy strategy;
            LinkedList<BranchingPolicy> policiesToUse = new LinkedList<BranchingPolicy>(this.qualifierBranchingPolicies);
            if (this.useDefaultBranchingPolicy) {
                policiesToUse.add(BranchingPolicy.DEFAULT_FALLBACK);
            }
            VersionNamingConfiguration vnc = new VersionNamingConfiguration(this.findTagVersionPattern, policiesToUse.toArray(new BranchingPolicy[policiesToUse.size()]));
            if (this.mavenLike) {
                MavenVersionStrategy mavenStrategy = new MavenVersionStrategy(vnc, this.repository, git, this.metadatas);
                mavenStrategy.setUseDirty(this.useDirty);
                strategy = mavenStrategy;
            } else {
                ConfigurableVersionStrategy cvs = new ConfigurableVersionStrategy(vnc, this.repository, git, this.metadatas);
                cvs.setAutoIncrementPatch(this.autoIncrementPatch);
                cvs.setUseDistance(this.useDistance);
                cvs.setUseDirty(this.useDirty);
                cvs.setUseGitCommitId(this.useGitCommitId);
                cvs.setGitCommitIdLength(this.gitCommitIdLength);
                strategy = cvs;
            }
            Version version = this.buildVersion(git, strategy);
            return version;
        }
    }

    public String getVersion() {
        return this.getVersionObject().toString();
    }

    private Version buildVersion(Git git, VersionStrategy strategy) {
        try {
            this.metadatas.registerMetadata(Metadatas.DIRTY, "" + GitUtils.isDirty(git));
            List allTags = git.tagList().call().stream().map(this::peel).collect(Collectors.toCollection(ArrayList::new));
            Collections.reverse(allTags);
            this.metadatas.registerMetadataTags(Metadatas.ALL_TAGS, allTags.stream());
            this.metadatas.registerMetadataTags(Metadatas.ALL_ANNOTATED_TAGS, allTags.stream().filter(GitUtils::isAnnotated));
            this.metadatas.registerMetadataTags(Metadatas.ALL_LIGHTWEIGHT_TAGS, allTags.stream().filter(Lambdas.as(GitUtils::isAnnotated).negate()));
            List allVersionTags = allTags.stream().filter(strategy::considerTagAsAVersionOne).collect(Collectors.toCollection(ArrayList::new));
            List<Ref> normals = allVersionTags.stream().filter(GitUtils::isAnnotated).collect(Collectors.toList());
            List<Ref> lights = allVersionTags.stream().filter(Lambdas.as(GitUtils::isAnnotated).negate()).collect(Collectors.toList());
            this.metadatas.registerMetadataTags(Metadatas.ALL_VERSION_TAGS, allVersionTags.stream());
            this.metadatas.registerMetadataTags(Metadatas.ALL_VERSION_ANNOTATED_TAGS, normals.stream());
            this.metadatas.registerMetadataTags(Metadatas.ALL_VERSION_LIGHTWEIGHT_TAGS, lights.stream());
            ObjectId rootId = this.repository.resolve("HEAD");
            if (rootId == null) {
                return Version.EMPTY_REPOSITORY_VERSION;
            }
            git.log().add((AnyObjectId)rootId).setMaxCount(1).call().spliterator().tryAdvance(rc -> {
                PersonIdent commitInfo = rc.getAuthorIdent();
                this.metadatas.registerMetadata(Metadatas.HEAD_COMMITTER_NAME, commitInfo.getName());
                this.metadatas.registerMetadata(Metadatas.HEAD_COMMITER_EMAIL, commitInfo.getEmailAddress());
                this.dtfmt.setTimeZone(commitInfo.getTimeZone());
                this.metadatas.registerMetadata(Metadatas.HEAD_COMMIT_DATETIME, this.dtfmt.format(commitInfo.getWhen()));
            });
            this.metadatas.registerMetadataTags(Metadatas.HEAD_TAGS, this.tagsOf(allTags, rootId).stream());
            this.metadatas.registerMetadataTags(Metadatas.HEAD_ANNOTATED_TAGS, this.tagsOf(allTags.stream().filter(GitUtils::isAnnotated).collect(Collectors.toList()), rootId).stream());
            this.metadatas.registerMetadataTags(Metadatas.HEAD_LIGHTWEIGHT_TAGS, this.tagsOf(allTags.stream().filter(Lambdas.as(GitUtils::isAnnotated).negate()).collect(Collectors.toList()), rootId).stream());
            this.metadatas.registerMetadata(Metadatas.GIT_SHA1_FULL, rootId.getName());
            this.metadatas.registerMetadata(Metadatas.GIT_SHA1_8, rootId.getName().substring(0, 8));
            Commit head = new Commit(rootId, 0, this.tagsOf(normals, rootId), this.tagsOf(lights, rootId));
            LinkedList<Commit> commits = new LinkedList<Commit>();
            try (RevWalk revWalk = new RevWalk(this.repository);){
                revWalk.markStart(revWalk.parseCommit((AnyObjectId)rootId));
                int depth = 0;
                ObjectId id = null;
                for (RevCommit rc2 : revWalk) {
                    id = rc2.getId();
                    List<Ref> annotatedCommitTags = this.tagsOf(normals, id);
                    List<Ref> lightCommitTags = this.tagsOf(lights, id);
                    if (annotatedCommitTags.size() > 0 || lightCommitTags.size() > 0) {
                        Commit c = new Commit(id, depth, annotatedCommitTags, lightCommitTags);
                        commits.add(c);
                        if (VersionStrategy.StrategySearchMode.STOP_AT_FIRST.equals((Object)strategy.searchMode()) || depth >= strategy.searchDepthLimit()) break;
                    }
                    ++depth;
                }
                if (commits.size() == 0) {
                    commits.add(new Commit(id, depth - 1, Collections.emptyList(), Collections.emptyList()));
                }
            }
            Version version = strategy.build(head, commits);
            this.metadatas.registerMetadata(Metadatas.CALCULATED_VERSION, version.toString());
            return version;
        }
        catch (Exception ex) {
            throw new IllegalStateException("failure calculating version", ex);
        }
    }

    private List<Ref> tagsOf(List<Ref> tags, ObjectId id) {
        return tags.stream().filter(ref -> id.equals((AnyObjectId)ref.getObjectId()) || id.equals((AnyObjectId)ref.getPeeledObjectId())).collect(Collectors.toList());
    }

    private Ref peel(Ref tag) {
        return this.repository.peel(tag);
    }

    @Override
    public void close() throws Exception {
        if (this.repository != null) {
            this.repository.close();
        }
    }

    public GitVersionCalculator setAutoIncrementPatch(boolean value) {
        this.autoIncrementPatch = value;
        return this;
    }

    public GitVersionCalculator setNonQualifierBranches(String nonQualifierBranches) {
        LinkedList<BranchingPolicy> branchPolicies = new LinkedList<BranchingPolicy>();
        if (nonQualifierBranches != null && !"".equals(nonQualifierBranches.trim())) {
            for (String branch : nonQualifierBranches.split(",")) {
                branchPolicies.add(BranchingPolicy.fixedBranchName(branch, Collections.singletonList(BranchingPolicy.BranchNameTransformations.IGNORE.name())));
            }
        }
        return this.setQualifierBranchingPolicies(branchPolicies);
    }

    public GitVersionCalculator setQualifierBranchingPolicies(BranchingPolicy ... policies) {
        return this.setQualifierBranchingPolicies(Arrays.asList(policies));
    }

    public GitVersionCalculator setQualifierBranchingPolicies(List<BranchingPolicy> policies) {
        if (policies != null) {
            this.qualifierBranchingPolicies = new LinkedList<BranchingPolicy>(policies);
        }
        return this;
    }

    public GitVersionCalculator setUseDistance(boolean useDistance) {
        this.useDistance = useDistance;
        return this;
    }

    public GitVersionCalculator setUseDirty(boolean useDirty) {
        this.useDirty = useDirty;
        return this;
    }

    public GitVersionCalculator setUseGitCommitId(boolean useGitCommitId) {
        this.useGitCommitId = useGitCommitId;
        return this;
    }

    public GitVersionCalculator setUseDefaultBranchingPolicy(boolean useDefaultBranchingPolicy) {
        this.useDefaultBranchingPolicy = useDefaultBranchingPolicy;
        return this;
    }

    public GitVersionCalculator setGitCommitIdLength(int gitCommitIdLength) {
        if (gitCommitIdLength < 8 || gitCommitIdLength > 40) {
            throw new IllegalStateException("GitCommitIdLength must be between 8 & 40");
        }
        this.gitCommitIdLength = gitCommitIdLength;
        return this;
    }

    public GitVersionCalculator setMavenLike(boolean mavenLike) {
        this.mavenLike = mavenLike;
        return this;
    }

    public GitVersionCalculator setFindTagVersionPattern(String pattern) {
        this.findTagVersionPattern = Pattern.compile(pattern);
        return this;
    }

    @Override
    public Optional<String> meta(Metadatas meta) {
        if (this.metadatas == null) {
            this.getVersion();
        }
        return this.metadatas.meta(meta);
    }
}

