/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version {
    public static final Version DEFAULT_VERSION = new Version(0, 0, 0, new String[0]);
    public static final Version EMPTY_REPOSITORY_VERSION = DEFAULT_VERSION.addQualifier("EMPTY_GIT_REPOSITORY");
    public static final Version NOT_GIT_VERSION = DEFAULT_VERSION.addQualifier("NOT_A_GIT_REPOSITORY");
    private final int major;
    private final int minor;
    private final int patch;
    private String stringRepresentation;
    private List<String> qualifiers;
    private static final Pattern globalVersionPattern = Pattern.compile("^([0-9]+)(?:\\.([0-9]+))?(?:\\.([0-9]+))?(\\-[a-zA-Z0-9][a-zA-Z0-9\\-_]*)?$");

    public Version(int major, int minor, int patch, String ... qualifiers) {
        this(major, minor, patch, Arrays.asList(qualifiers));
    }

    private Version(int major, int minor, int patch, List<String> qualifiers) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.qualifiers = qualifiers;
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%d.%d.%d", major, minor, patch));
        this.qualifiers.forEach(q -> sb.append('-').append((String)q));
        this.stringRepresentation = sb.toString();
    }

    public String toString() {
        return this.stringRepresentation;
    }

    public Version addQualifier(String qualifier) {
        ArrayList<String> newQualifiers = new ArrayList<String>(this.qualifiers);
        newQualifiers.add(qualifier);
        return new Version(this.major, this.minor, this.patch, newQualifiers.toArray(new String[newQualifiers.size()]));
    }

    public Version removeQualifier(String qualifier) {
        ArrayList<String> newQualifiers = new ArrayList<String>(this.qualifiers);
        newQualifiers.remove(qualifier);
        return new Version(this.major, this.minor, this.patch, newQualifiers.toArray(new String[newQualifiers.size()]));
    }

    public Version noQualifier() {
        return new Version(this.major, this.minor, this.patch, Collections.emptyList());
    }

    public static Version parse(String versionAsString) {
        Matcher globalVersionMatcher = globalVersionPattern.matcher(versionAsString);
        if (globalVersionMatcher.matches()) {
            int major = Integer.parseInt(globalVersionMatcher.group(1));
            int minor = Integer.parseInt(Optional.ofNullable(globalVersionMatcher.group(2)).orElse("0"));
            int patch = Integer.parseInt(Optional.ofNullable(globalVersionMatcher.group(3)).orElse("0"));
            String qualifiersAsString = globalVersionMatcher.group(4);
            String[] qualifiers = new String[]{};
            if (qualifiersAsString != null) {
                qualifiers = qualifiersAsString.replaceFirst("-", "").split("\\-");
            }
            return new Version(major, minor, patch, qualifiers);
        }
        throw new IllegalStateException("cannot parse " + versionAsString + " as a semver compatible version");
    }

    public Version increasePatch() {
        return new Version(this.major, this.minor, this.patch + 1, this.qualifiers);
    }

    public boolean isSnapshot() {
        return this.qualifiers.stream().anyMatch("SNAPSHOT"::equals);
    }

    public boolean isQualified() {
        return this.qualifiers.size() > 0;
    }
}

