/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver.impl;

import fr.brouillard.oss.jgitver.Version;
import fr.brouillard.oss.jgitver.VersionCalculationException;
import fr.brouillard.oss.jgitver.impl.Commit;
import fr.brouillard.oss.jgitver.impl.GitUtils;
import fr.brouillard.oss.jgitver.impl.VersionNamingConfiguration;
import fr.brouillard.oss.jgitver.impl.VersionStrategy;
import fr.brouillard.oss.jgitver.metadata.MetadataRegistrar;
import fr.brouillard.oss.jgitver.metadata.Metadatas;
import java.util.List;
import java.util.Optional;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

public class ConfigurableVersionStrategy
extends VersionStrategy {
    private boolean autoIncrementPatch = false;
    private boolean useDistance = true;
    private boolean useGitCommitId = false;
    private int gitCommitIdLength = 8;
    private boolean useDirty = false;

    public ConfigurableVersionStrategy(VersionNamingConfiguration vnc, Repository repository, Git git, MetadataRegistrar metadatas) {
        super(vnc, repository, git, metadatas);
    }

    public ConfigurableVersionStrategy setAutoIncrementPatch(boolean autoIncrementPatch) {
        this.autoIncrementPatch = autoIncrementPatch;
        return this;
    }

    public ConfigurableVersionStrategy setUseDistance(boolean useDistance) {
        this.useDistance = useDistance;
        return this;
    }

    public ConfigurableVersionStrategy setUseGitCommitId(boolean useGitCommitId) {
        this.useGitCommitId = useGitCommitId;
        return this;
    }

    public ConfigurableVersionStrategy setGitCommitIdLength(int gitCommitIdLength) {
        this.gitCommitIdLength = gitCommitIdLength;
        return this;
    }

    public ConfigurableVersionStrategy setUseDirty(boolean useDirty) {
        this.useDirty = useDirty;
        return this;
    }

    @Override
    public Version build(Commit head, List<Commit> parents) throws VersionCalculationException {
        try {
            Version baseVersion;
            Commit base = parents.get(0);
            Ref tagToUse = this.isBaseCommitOnHead(head, base) && !GitUtils.isDirty(this.getGit()) ? base.getAnnotatedTags().stream().findFirst().orElseGet(() -> base.getLightTags().stream().findFirst().orElse(null)) : base.getLightTags().stream().findFirst().orElseGet(() -> base.getAnnotatedTags().stream().findFirst().orElse(null));
            if (tagToUse == null) {
                baseVersion = Version.DEFAULT_VERSION;
            } else {
                String tagName = GitUtils.tagNameFromRef(tagToUse);
                this.getRegistrar().registerMetadata(Metadatas.BASE_TAG, tagName);
                baseVersion = Version.parse(this.getVersionNamingConfiguration().extractVersionFrom(tagName));
            }
            boolean useSnapshot = baseVersion.isSnapshot();
            if (!this.isBaseCommitOnHead(head, base) && this.autoIncrementPatch && GitUtils.isAnnotated(tagToUse)) {
                baseVersion = baseVersion.increasePatch();
            }
            if (this.useDistance && !useSnapshot) {
                if (tagToUse == null) {
                    baseVersion = baseVersion.addQualifier("" + base.getHeadDistance());
                } else if (!this.isBaseCommitOnHead(head, base) || !GitUtils.isAnnotated(tagToUse)) {
                    baseVersion = baseVersion.addQualifier("" + base.getHeadDistance());
                }
            }
            if (this.useGitCommitId && !this.isBaseCommitOnHead(head, base)) {
                baseVersion = baseVersion.addQualifier(head.getGitObject().getName().substring(0, this.gitCommitIdLength));
            }
            if (!GitUtils.isDetachedHead(this.getRepository())) {
                this.getRegistrar().registerMetadata(Metadatas.BRANCH_NAME, this.getRepository().getBranch());
                Optional<String> branchQualifier = this.getVersionNamingConfiguration().branchQualifier(this.getRepository().getBranch());
                if (branchQualifier.isPresent()) {
                    baseVersion = baseVersion.addQualifier(branchQualifier.get());
                }
            }
            if (this.useDirty && GitUtils.isDirty(this.getGit())) {
                baseVersion = baseVersion.addQualifier("dirty");
            }
            return useSnapshot ? baseVersion.removeQualifier("SNAPSHOT").addQualifier("SNAPSHOT") : baseVersion;
        }
        catch (Exception ex) {
            throw new VersionCalculationException("cannot compute version", ex);
        }
    }
}

