/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver.impl;

import java.io.IOException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

public class GitUtils {
    public static String tagNameFromRef(Ref tag) {
        return tag.getName().replace("refs/tags/", "");
    }

    public static boolean isAnnotated(Ref ref) {
        return ref != null && ref.getPeeledObjectId() != null;
    }

    public static String sanitizeBranchName(String currentBranch) {
        return currentBranch.replaceAll("[\\s\\-#/\\\\]+", "_");
    }

    public static boolean isDetachedHead(Repository repository) throws IOException {
        return repository.getFullBranch().matches("[0-9a-f]{40}");
    }

    public static boolean isDirty(Git git) throws NoWorkTreeException, GitAPIException {
        Status status = git.status().call();
        return !status.isClean();
    }
}

