/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver.impl;

import fr.brouillard.oss.jgitver.Version;
import fr.brouillard.oss.jgitver.VersionCalculationException;
import fr.brouillard.oss.jgitver.impl.Commit;
import fr.brouillard.oss.jgitver.impl.GitUtils;
import fr.brouillard.oss.jgitver.impl.VersionNamingConfiguration;
import fr.brouillard.oss.jgitver.impl.VersionStrategy;
import fr.brouillard.oss.jgitver.metadata.MetadataRegistrar;
import fr.brouillard.oss.jgitver.metadata.Metadatas;
import java.util.List;
import java.util.Optional;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

public class MavenVersionStrategy
extends VersionStrategy {
    private boolean useDirty = false;

    public MavenVersionStrategy(VersionNamingConfiguration vnc, Repository repository, Git git, MetadataRegistrar metadatas) {
        super(vnc, repository, git, metadatas);
    }

    @Override
    public Version build(Commit head, List<Commit> parentsWithTags) throws VersionCalculationException {
        try {
            Commit base = parentsWithTags.get(0);
            Ref tagToUse = this.isBaseCommitOnHead(head, base) && !GitUtils.isDirty(this.getGit()) ? base.getAnnotatedTags().stream().findFirst().orElseGet(() -> base.getLightTags().stream().findFirst().orElse(null)) : base.getLightTags().stream().findFirst().orElseGet(() -> base.getAnnotatedTags().stream().findFirst().orElse(null));
            Version baseVersion = null;
            boolean needSnapshot = false;
            if (tagToUse == null) {
                baseVersion = Version.DEFAULT_VERSION;
                needSnapshot = true;
            } else {
                String tagName = GitUtils.tagNameFromRef(tagToUse);
                this.getRegistrar().registerMetadata(Metadatas.BASE_TAG, tagName);
                baseVersion = Version.parse(this.getVersionNamingConfiguration().extractVersionFrom(tagName));
                boolean bl = needSnapshot = baseVersion.isSnapshot() || !this.isBaseCommitOnHead(head, base) || !GitUtils.isAnnotated(tagToUse);
            }
            if (!this.isBaseCommitOnHead(head, base)) {
                if (GitUtils.isAnnotated(tagToUse) && !baseVersion.removeQualifier("SNAPSHOT").isQualified()) {
                    baseVersion = baseVersion.increasePatch();
                }
                baseVersion = baseVersion.noQualifier();
            }
            if (!GitUtils.isDetachedHead(this.getRepository())) {
                this.getRegistrar().registerMetadata(Metadatas.BRANCH_NAME, this.getRepository().getBranch());
                Optional<String> branchQualifier = this.getVersionNamingConfiguration().branchQualifier(this.getRepository().getBranch());
                if (branchQualifier.isPresent()) {
                    baseVersion = baseVersion.addQualifier(branchQualifier.get());
                }
            }
            if (this.useDirty && GitUtils.isDirty(this.getGit())) {
                baseVersion = baseVersion.addQualifier("dirty");
            }
            return needSnapshot ? baseVersion.removeQualifier("SNAPSHOT").addQualifier("SNAPSHOT") : baseVersion;
        }
        catch (Exception ex) {
            throw new VersionCalculationException("cannot compute version", ex);
        }
    }

    public void setUseDirty(boolean useDirty) {
        this.useDirty = useDirty;
    }
}

