/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver.impl;

import fr.brouillard.oss.jgitver.Version;
import fr.brouillard.oss.jgitver.VersionCalculationException;
import fr.brouillard.oss.jgitver.impl.Commit;
import fr.brouillard.oss.jgitver.impl.VersionNamingConfiguration;
import fr.brouillard.oss.jgitver.metadata.MetadataRegistrar;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

public abstract class VersionStrategy {
    private VersionNamingConfiguration vnc;
    private Repository repository;
    private Git git;
    private MetadataRegistrar registrar;

    protected MetadataRegistrar getRegistrar() {
        return this.registrar;
    }

    public VersionStrategy(VersionNamingConfiguration vnc, Repository repository, Git git, MetadataRegistrar registrar) {
        this.vnc = vnc;
        this.repository = repository;
        this.git = git;
        this.registrar = registrar;
    }

    public abstract Version build(Commit var1, List<Commit> var2) throws VersionCalculationException;

    public int searchDepthLimit() {
        return Integer.MAX_VALUE;
    }

    public boolean considerTagAsAVersionOne(Ref tag) {
        String tagName = this.tagNameFromRef(tag);
        return this.getVersionNamingConfiguration().getSearchPattern().matcher(tagName).matches();
    }

    public StrategySearchMode searchMode() {
        return StrategySearchMode.STOP_AT_FIRST;
    }

    private String tagNameFromRef(Ref tag) {
        return tag.getName().replace("refs/tags/", "");
    }

    protected VersionNamingConfiguration getVersionNamingConfiguration() {
        return this.vnc;
    }

    protected Repository getRepository() {
        return this.repository;
    }

    protected Git getGit() {
        return this.git;
    }

    protected boolean isBaseCommitOnHead(Commit head, Commit base) {
        return head.getGitObject().name().equals(base.getGitObject().name());
    }

    public static enum StrategySearchMode {
        STOP_AT_FIRST,
        DEPTH;

    }
}

